/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.collect.Sets;
import com.xdja.csagent.engine.Agent;
import com.xdja.csagent.engine.AgentConnection;
import com.xdja.csagent.engine.IWidget;
import com.xdja.csagent.engine.MakerUtils;
import com.xdja.csagent.engine.PortContext;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.engine.bean.EngineParams;
import com.xdja.csagent.engine.metrics.MetricsFactory;
import com.xdja.csagent.engine.plugins.IConnectionPlugin;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortListenManager
implements IWidget {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EngineParams engineParams;
    private ServerBootstrap serverBootstrap;
    private ConcurrentMap<Integer, PortContext> portContextMap = new ConcurrentHashMap<Integer, PortContext>();
    private ConcurrentMap<Integer, NioServerSocketChannel> serverSocketChannelMap = new ConcurrentHashMap<Integer, NioServerSocketChannel>();
    private Meter createMeter = MetricsFactory.metrics().meter("frontend.connection.create.meter");
    private Meter closeMeter = MetricsFactory.metrics().meter("frontend.connection.close.meter");
    private Timer connTimer = MetricsFactory.metrics().timer("frontend.connection.timer");
    private final Set<IConnectionPlugin> connectionPluginSet = Sets.newConcurrentHashSet();

    public PortListenManager(EngineParams engineParams) {
        this.engineParams = engineParams;
    }

    public void addConnectionPlugin(IConnectionPlugin connectionPlugin) {
        this.connectionPluginSet.add(connectionPlugin);
    }

    private void bindListen(Integer agentPort) throws InterruptedException {
        NioServerSocketChannel serverSocketChannel = (NioServerSocketChannel)this.serverBootstrap.bind(agentPort.intValue()).sync().channel();
        this.serverSocketChannelMap.put(agentPort, serverSocketChannel);
    }

    public Set<Integer> getListenPorts() {
        return this.portContextMap.keySet();
    }

    public PortContext getPortContext(Integer port) {
        return (PortContext)this.portContextMap.get(port);
    }

    public void onChannelInit(int port, SocketChannel channel) {
        if (Utils.EnableLogging) {
            channel.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO)});
        }
        if (!this.portContextMap.containsKey(port)) {
            this.logger.warn("\u7aef\u53e3{}\u65e0\u670d\u52a1\uff1f", (Object)port);
            channel.close();
            return;
        }
        PortContext portContext = (PortContext)this.portContextMap.get(port);
        channel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, this.engineParams.getConnectIdleMillis() / 1000)});
        final AgentConnection conn = MakerUtils.getMaker(portContext.getAgentType()).makeFrontend((Channel)channel, portContext);
        conn.setConnectionPlugins(Collections.unmodifiableSet(this.connectionPluginSet));
        channel.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
            private Timer.Context time;

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                this.time = PortListenManager.this.connTimer.time();
                PortListenManager.this.createMeter.mark();
                super.channelActive(ctx);
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                super.channelInactive(ctx);
                PortListenManager.this.closeMeter.mark();
                this.time.stop();
            }

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                IdleStateEvent e;
                if (evt instanceof IdleStateEvent && (e = (IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
                    PortListenManager.this.logger.warn("Connection {} idle {} seconds , will close !!!", (Object)conn.id(), (Object)(PortListenManager.this.engineParams.getConnectIdleMillis() / 1000));
                    ctx.close();
                }
            }
        }});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerListen(Agent agent) throws Exception {
        Integer agentPort = agent.getAgentPort();
        if (this.portContextMap.containsKey(agentPort)) {
            PortContext portContext = (PortContext)this.portContextMap.get(agentPort);
            if (!MakerUtils.getMaker(portContext.getAgentType()).supportPortShare().booleanValue()) throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7aef\u53e3\u5171\u4eab!");
            portContext.addAgentService(agent);
            return;
        } else {
            if (this.serverBootstrap == null) {
                this.startup();
            }
            this.bindListen(agentPort);
            PortContext portContext = new PortContext(agentPort, agent.getAgentType());
            portContext.addAgentService(agent);
            this.portContextMap.put(agentPort, portContext);
        }
    }

    public void removeConnectionPlugin(IConnectionPlugin connectionPlugin) {
        this.connectionPluginSet.add(connectionPlugin);
    }

    @Override
    public void shutdown() {
        for (NioServerSocketChannel nioServerSocketChannel : this.serverSocketChannelMap.values()) {
            nioServerSocketChannel.close().syncUninterruptibly();
        }
        for (IConnectionPlugin iConnectionPlugin : this.connectionPluginSet) {
            iConnectionPlugin.onPluginDestroy();
        }
        if (this.serverBootstrap != null) {
            this.serverBootstrap.group().shutdownGracefully().awaitUninterruptibly();
            this.serverBootstrap.childGroup().shutdownGracefully().awaitUninterruptibly();
            this.serverBootstrap = null;
        }
        this.logger.info("Stop Listen Service Success!!!");
    }

    @Override
    public boolean isRunning() {
        return this.serverBootstrap != null;
    }

    @Override
    public void startup() throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory("AgentFrontend-BOSS"));
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("AgentFrontend-WORKER"));
        this.serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                int port = ch.localAddress().getPort();
                PortListenManager.this.logger.debug("initChannel : {}", (Object)ch.toString());
                PortListenManager.this.onChannelInit(port, ch);
            }
        }).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)10000)).option(ChannelOption.SO_TIMEOUT, (Object)5000)).childOption(ChannelOption.AUTO_READ, (Object)false);
    }

    public void unregisterListen(Agent agent) {
        Integer agentPort = agent.getAgentPort();
        if (this.portContextMap.containsKey(agentPort)) {
            PortContext portContext = (PortContext)this.portContextMap.get(agentPort);
            portContext.removeAgentService(agent);
            if (!portContext.hasAgentService()) {
                this.portContextMap.remove(agentPort);
                NioServerSocketChannel serverSocketChannel = (NioServerSocketChannel)this.serverSocketChannelMap.remove(agentPort);
                if (serverSocketChannel != null) {
                    serverSocketChannel.close().syncUninterruptibly();
                }
            }
        } else {
            this.logger.warn("\u627e\u4e0d\u5230\u8981unregister\u7684port,agentService:{},port:{}", (Object)agent.getAgentMeta().getId(), (Object)agentPort);
        }
    }
}

