/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine.impl.frontend;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.EncoderUtils;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class HttpDetectorHandler
extends SimpleChannelInboundHandler<byte[]> {
    public static final byte TYPE_PASS = 1;
    public static final byte TYPE_NOT_PASS = 0;
    public static final byte TYPE_UNKNOWN = -1;
    public static final Logger LOGGER = LoggerFactory.getLogger(HttpDetectorHandler.class);
    private byte letPass = (byte)-1;
    private byte[] buffer;
    private int limitSize;
    private int offset;
    private static final List<String> HTTP_VERSION_LIST = Arrays.asList("HTTP/1.0", "HTTP/1.1");
    private static final List<String> HTTP_METHOD_LIST = Arrays.asList("OPTIONS", "GET", "HEAD", "POST", "PUT", "PATCH", "DELETE", "TRACE", "CONNECT");

    public HttpDetectorHandler(int limitSize) {
        Assert.isTrue((limitSize > 0 ? 1 : 0) != 0);
        this.limitSize = limitSize;
        this.offset = 0;
        this.buffer = new byte[limitSize];
    }

    public HttpDetectorHandler() {
        this(8192);
    }

    protected void channelRead0(ChannelHandlerContext ctx, byte[] msg) throws Exception {
        if (this.letPass == 1) {
            ctx.fireChannelRead((Object)msg);
        } else {
            this.processInitialLine(msg);
            if (this.letPass == 0) {
                LOGGER.warn("UNAUTHORIZED http protocol in TcpForward : {} -> {}", (Object)ctx.channel().remoteAddress().toString(), (Object)ctx.channel().localAddress().toString());
                DefaultFullHttpResponse notAllow = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED);
                byte[] bytes = EncoderUtils.encodehttpResponse((HttpResponse)notAllow);
                ctx.writeAndFlush((Object)bytes).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                ctx.fireChannelRead((Object)msg);
            }
            if (this.letPass == 1) {
                LOGGER.debug("{} -> {} is not a http TcpForward!", (Object)ctx.channel().remoteAddress().toString(), (Object)ctx.channel().localAddress().toString());
                this.cleanResource();
            }
        }
    }

    private void cleanResource() {
        this.buffer = null;
    }

    private void processInitialLine(byte[] msg) {
        for (byte one : msg) {
            if (one != 13 && one != 10) {
                this.buffer[this.offset++] = one;
                if (this.offset < this.limitSize) continue;
                this.letPass = 1;
                return;
            }
            if (one != 10) continue;
            this.letPass = this.checkHttpInitialLine();
            return;
        }
    }

    private byte checkHttpInitialLine() {
        String httpMethod;
        String httpVersion;
        String line = new String(this.buffer, 0, this.offset);
        String[] initialLine = HttpDetectorHandler.splitInitialLine(line);
        if (initialLine.length == 3 && HTTP_VERSION_LIST.contains(httpVersion = initialLine[2].toUpperCase()) && HTTP_METHOD_LIST.contains(httpMethod = initialLine[0].toUpperCase())) {
            return 0;
        }
        return 1;
    }

    private static String[] splitInitialLine(String sb) {
        int aStart = HttpDetectorHandler.findNonWhitespace(sb, 0);
        int aEnd = HttpDetectorHandler.findWhitespace(sb, aStart);
        int bStart = HttpDetectorHandler.findNonWhitespace(sb, aEnd);
        int bEnd = HttpDetectorHandler.findWhitespace(sb, bStart);
        int cStart = HttpDetectorHandler.findNonWhitespace(sb, bEnd);
        int cEnd = HttpDetectorHandler.findEndOfString(sb);
        return new String[]{sb.substring(aStart, aEnd), sb.substring(bStart, bEnd), cStart < cEnd ? sb.substring(cStart, cEnd) : ""};
    }

    private static int findNonWhitespace(CharSequence sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    private static int findWhitespace(CharSequence sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && !Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    private static int findEndOfString(CharSequence sb) {
        int result;
        for (result = sb.length(); result > 0 && Character.isWhitespace(sb.charAt(result - 1)); --result) {
        }
        return result;
    }
}

