/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine.impl.frontend;

import com.xdja.csagent.engine.Agent;
import com.xdja.csagent.engine.AgentConnection;
import com.xdja.csagent.engine.IConnPacketListener;
import com.xdja.csagent.engine.PortContext;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.engine.impl.custom.CustomHttpRequestDecoder;
import com.xdja.csagent.engine.packet.ChannelPacket;
import com.xdja.csagent.engine.packet.ConnectBegin;
import com.xdja.csagent.engine.packet.DataPacket;
import com.xdja.csagent.engine.packet.FeedbackPacket;
import com.xdja.csagent.engine.plugins.IConnectionPlugin;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.handler.codec.http.EncoderUtils;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyFrontendConnection
extends AgentConnection {
    public final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Agent agent;
    private final Queue<ChannelPacket> dataQueue = new ConcurrentLinkedQueue<ChannelPacket>();
    private final CustomHttpRequestDecoder customHttpRequestDecoder;
    protected String requestUrl;
    private boolean isLastContent = false;
    private long timeConnect;
    private long timeRequest;
    private long timeResponse;
    private long sizeRequest = 0L;
    private long sizeResponse = 0L;

    public HttpProxyFrontendConnection(String id, Channel channel, PortContext portContext) {
        super(id, channel);
        this.agent = portContext.getFirstAgentService();
        this.customHttpRequestDecoder = new CustomHttpRequestDecoder();
        this.init(channel);
    }

    private boolean activeIntercept(ChannelHandlerContext ctx) {
        try {
            for (IConnectionPlugin plugin : this.getConnectionPlugins()) {
                if (!plugin.activeIntercept(ctx.channel(), this.agent.getAgentMeta(), null)) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Connection Plugin Execute Error!", (Throwable)e);
        }
        return false;
    }

    public void addBuffer(ChannelPacket packet) {
        this.dataQueue.add(packet);
    }

    @Override
    public void applyNewConfig() {
        try {
            for (IConnectionPlugin plugin : this.getConnectionPlugins()) {
                plugin.applyNewConfig(this.channel(), this.agent.getAgentMeta());
            }
        }
        catch (Exception e) {
            this.logger.error("Connection Plugin Execute Error!", (Throwable)e);
        }
    }

    protected boolean doHttpRequestFilter(ChannelHandlerContext ctx, String destHost, int destPort, String destPath) {
        try {
            for (IConnectionPlugin plugin : this.getConnectionPlugins()) {
                if (!plugin.httpRequestIntercept(ctx.channel(), this.agent.getAgentMeta(), null, destHost, destPort, destPath)) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Connection Plugin Execute Error!", (Throwable)e);
        }
        return false;
    }

    private ConnectBegin getConnectBegin(ChannelHandlerContext ctx, HttpRequest request) throws MalformedURLException {
        String host;
        int port = 80;
        if (request.headers().contains("Host")) {
            String tmp = request.headers().get("Host");
            int indexOf = tmp.indexOf(":");
            if (indexOf > -1) {
                host = tmp.substring(0, indexOf);
                port = Integer.parseInt(tmp.substring(indexOf + 1));
            } else {
                host = tmp;
            }
        } else {
            URL uri = Utils.fixUrl(request.getUri());
            host = uri.getHost();
            port = uri.getPort();
        }
        ConnectBegin connectBegin = new ConnectBegin(this.id(), 3);
        connectBegin.setHost(host);
        connectBegin.setPort(port);
        return connectBegin;
    }

    private void init(Channel channel) {
        channel.pipeline().addLast(new ChannelHandler[]{this.customHttpRequestDecoder});
        channel.pipeline().addLast(new ChannelHandler[]{new ByteArrayEncoder()});
        channel.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<HttpObject>(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                if (!HttpProxyFrontendConnection.this.activeIntercept(ctx)) {
                    HttpProxyFrontendConnection.this.agent.addConnection(HttpProxyFrontendConnection.this);
                    HttpProxyFrontendConnection.this.timeConnect = System.currentTimeMillis();
                    ctx.read();
                }
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                HttpProxyFrontendConnection.this.agent.removeConnection(HttpProxyFrontendConnection.this);
                if (HttpProxyFrontendConnection.this.partnerClosed) {
                    HttpProxyFrontendConnection.this.logger.trace("\u5bf9\u7aef\u5df2\u5173\u95ed\uff0c\u65e0\u9700\u901a\u77e5");
                } else {
                    HttpProxyFrontendConnection.this.logger.trace("notify: connection close");
                    HttpProxyFrontendConnection.this.agent.sendToRoute(new FeedbackPacket(HttpProxyFrontendConnection.this.id(), 1));
                }
                HttpProxyFrontendConnection.this.logger.debug("INACTIVE " + ctx.channel().toString());
            }

            protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
                if (msg instanceof HttpRequest) {
                    HttpProxyFrontendConnection.this.isLastContent = false;
                    HttpRequest request = (HttpRequest)msg;
                    URL uri = Utils.fixUrl(request.getUri());
                    HttpProxyFrontendConnection.this.logger.debug("dest uri : {}", (Object)uri.toString());
                    HttpProxyFrontendConnection.this.requestUrl = uri.toExternalForm();
                    if (!HttpProxyFrontendConnection.this.doHttpRequestFilter(ctx, uri.getHost(), uri.getPort(), uri.getPath())) {
                        ConnectBegin connectBegin = HttpProxyFrontendConnection.this.getConnectBegin(ctx, request);
                        HttpProxyFrontendConnection.this.addBuffer(connectBegin);
                        DataPacket data = new DataPacket(HttpProxyFrontendConnection.this.id());
                        data.setLast(HttpProxyFrontendConnection.this.isLastContent);
                        if (HttpProxyFrontendConnection.this.agent.getEngineParams().getHttpHeaderReplaceEnable().booleanValue()) {
                            for (Map.Entry<String, String> one : HttpProxyFrontendConnection.this.agent.getEngineParams().getHttpHeaderReplaceSet()) {
                                request.headers().set(one.getKey(), (Object)one.getValue());
                            }
                        }
                        byte[] tmpData = EncoderUtils.encodeHttpRequest(request);
                        data.setData(tmpData);
                        HttpProxyFrontendConnection.this.addBuffer(data);
                        HttpProxyFrontendConnection.this.sizeRequest += tmpData.length;
                    }
                } else if (msg instanceof LastHttpContent) {
                    HttpProxyFrontendConnection.this.logger.trace("last request data read from channel");
                    HttpProxyFrontendConnection.this.isLastContent = true;
                }
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                byte[] bytes = HttpProxyFrontendConnection.this.customHttpRequestDecoder.pollCache();
                DataPacket data = new DataPacket(HttpProxyFrontendConnection.this.id());
                data.setData(bytes);
                data.setLast(HttpProxyFrontendConnection.this.isLastContent);
                if (HttpProxyFrontendConnection.this.isLastContent) {
                    HttpProxyFrontendConnection.this.timeRequest = System.currentTimeMillis();
                }
                HttpProxyFrontendConnection.this.addBuffer(data);
                HttpProxyFrontendConnection.this.sizeRequest += bytes.length;
                HttpProxyFrontendConnection.this.triggerSendToSwap();
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                HttpProxyFrontendConnection.this.logger.warn("\u8fde\u63a5\u672a\u77e5\u5f02\u5e38", cause);
                ctx.close();
            }
        }});
    }

    @Override
    public Boolean isRouteLocal() {
        return this.agent.isRouteLocal();
    }

    @Override
    protected IConnPacketListener newConnPacketListener() {
        return new IConnPacketListener(){

            @Override
            public void onPartnerConnectClose(AgentConnection agentConnection, FeedbackPacket feedback) {
                HttpProxyFrontendConnection.this.partnerClosed = true;
                Utils.closeOnFlush(HttpProxyFrontendConnection.this.channel());
            }

            @Override
            public void onPartnerConnectFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
                HttpProxyFrontendConnection.this.logger.info(HttpProxyFrontendConnection.this.requestUrl);
                HttpProxyFrontendConnection.this.partnerClosed = true;
                HttpProxyFrontendConnection.this.channel().close();
            }

            @Override
            public void onPartnerConnectSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
                ChannelPacket request = HttpProxyFrontendConnection.this.pollBuffer();
                HttpProxyFrontendConnection.this.logger.trace("notify: send request header data");
                HttpProxyFrontendConnection.this.agent.sendToRoute(request);
            }

            @Override
            public void onPartnerWriteFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
                HttpProxyFrontendConnection.this.channel().close();
            }

            @Override
            public void onPartnerWriteSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
                if (!HttpProxyFrontendConnection.this.triggerSendToSwap()) {
                    HttpProxyFrontendConnection.this.logger.trace("read data from channel");
                    HttpProxyFrontendConnection.this.channel().read();
                }
            }

            @Override
            public void receivePartnerData(AgentConnection agentConnection, DataPacket packet) {
                HttpProxyFrontendConnection.this.sizeResponse += packet.getData().length;
                final boolean last = packet.isLast();
                HttpProxyFrontendConnection.this.channel().writeAndFlush((Object)packet.getData()).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            if (!last) {
                                HttpProxyFrontendConnection.this.logger.trace("notify: write data success");
                                HttpProxyFrontendConnection.this.agent.sendToRoute(new FeedbackPacket(HttpProxyFrontendConnection.this.id(), 5));
                            } else {
                                HttpProxyFrontendConnection.this.logger.trace("last response data write success, will close");
                                HttpProxyFrontendConnection.this.timeResponse = System.currentTimeMillis();
                                HttpProxyFrontendConnection.this.showTimeAndSizeLog();
                                future.channel().close();
                            }
                        } else {
                            HttpProxyFrontendConnection.this.logger.trace("notify: write data failure", future.cause());
                            HttpProxyFrontendConnection.this.agent.sendToRoute(new FeedbackPacket(HttpProxyFrontendConnection.this.id(), 4));
                        }
                    }
                });
            }
        };
    }

    public ChannelPacket pollBuffer() {
        return this.dataQueue.poll();
    }

    private void showTimeAndSizeLog() {
        long requestUsed = this.timeRequest - this.timeConnect;
        long responseUsed = this.timeResponse - this.timeRequest;
        long totalUsed = requestUsed + responseUsed;
        this.logger.info("Http Proxy [{}] used {} ms, receive request {} ms, size {} byte. back response {} ms, size {} byte!", new Object[]{this.requestUrl, totalUsed, requestUsed, this.sizeRequest, responseUsed, this.sizeResponse});
    }

    public final boolean triggerSendToSwap() {
        ChannelPacket one = this.dataQueue.poll();
        if (one != null) {
            this.agent.sendToRoute(one);
            return true;
        }
        return false;
    }
}

