/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine.impl.frontend;

import com.xdja.csagent.engine.Agent;
import com.xdja.csagent.engine.AgentConnection;
import com.xdja.csagent.engine.IConnPacketListener;
import com.xdja.csagent.engine.PortContext;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.engine.impl.frontend.HttpDetectorHandler;
import com.xdja.csagent.engine.packet.ChannelPacket;
import com.xdja.csagent.engine.packet.ConnectBegin;
import com.xdja.csagent.engine.packet.DataPacket;
import com.xdja.csagent.engine.packet.FeedbackPacket;
import com.xdja.csagent.engine.plugins.IConnectionPlugin;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpForwardFrontendConnection
extends AgentConnection {
    public final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Agent agent;
    private final Queue<ChannelPacket> dataQueue = new ConcurrentLinkedQueue<ChannelPacket>();
    private String requestUrl;
    private long timeConnect;
    private long timeClose;
    private long sizeSend = 0L;
    private long sizeReceive = 0L;
    private boolean workSuccess = true;
    private HashMap<String, Object> pluginContext = new HashMap();

    public TcpForwardFrontendConnection(String id, Channel channel, PortContext portContext) {
        super(id, channel);
        this.agent = portContext.getFirstAgentService();
        this.init(channel);
    }

    private boolean activeIntercept(ChannelHandlerContext ctx) {
        try {
            for (IConnectionPlugin plugin : this.getConnectionPlugins()) {
                if (!plugin.activeIntercept(ctx.channel(), this.agent.getAgentMeta(), this.pluginContext)) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Connection Plugin Execute Error!", (Throwable)e);
        }
        return false;
    }

    public void addBuffer(ChannelPacket packet) {
        this.dataQueue.add(packet);
    }

    @Override
    public void applyNewConfig() {
        try {
            for (IConnectionPlugin plugin : this.getConnectionPlugins()) {
                plugin.applyNewConfig(this.channel(), this.agent.getAgentMeta());
            }
        }
        catch (Exception e) {
            this.logger.error("Connection Plugin Execute Error!", (Throwable)e);
        }
    }

    public String getForwardHost() {
        return this.agent.getAgentMeta().getDestHost();
    }

    public int getForwardPort() {
        return this.agent.getAgentMeta().getDestPort();
    }

    private void init(Channel channel) {
        channel.pipeline().addLast(new ChannelHandler[]{new ByteArrayDecoder()});
        channel.pipeline().addLast(new ChannelHandler[]{new ByteArrayEncoder()});
        if (this.agent.getAgentMeta().isDisableHttpProtocol()) {
            channel.pipeline().addLast(new ChannelHandler[]{new HttpDetectorHandler()});
        }
        channel.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<byte[]>(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                boolean intercepted = TcpForwardFrontendConnection.this.activeIntercept(ctx);
                if (!intercepted) {
                    TcpForwardFrontendConnection.this.agent.addConnection(TcpForwardFrontendConnection.this);
                    TcpForwardFrontendConnection.this.timeConnect = System.currentTimeMillis();
                    ConnectBegin connectBegin = new ConnectBegin(TcpForwardFrontendConnection.this.id(), 1);
                    connectBegin.setHost(TcpForwardFrontendConnection.this.getForwardHost());
                    connectBegin.setPort(TcpForwardFrontendConnection.this.getForwardPort());
                    TcpForwardFrontendConnection.this.requestUrl = TcpForwardFrontendConnection.this.getForwardHost() + ":" + TcpForwardFrontendConnection.this.getForwardPort();
                    TcpForwardFrontendConnection.this.agent.sendToRoute(connectBegin);
                    TcpForwardFrontendConnection.this.logger.trace("notify: try connect {}", (Object)(TcpForwardFrontendConnection.this.getForwardHost() + ":" + TcpForwardFrontendConnection.this.getForwardPort()));
                }
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                TcpForwardFrontendConnection.this.timeClose = System.currentTimeMillis();
                for (IConnectionPlugin plugin : TcpForwardFrontendConnection.this.getConnectionPlugins()) {
                    plugin.onConnectOver(TcpForwardFrontendConnection.this.agent, TcpForwardFrontendConnection.this.pluginContext, TcpForwardFrontendConnection.this.requestUrl, TcpForwardFrontendConnection.this.workSuccess, TcpForwardFrontendConnection.this.timeConnect, System.currentTimeMillis(), (int)(TcpForwardFrontendConnection.this.sizeReceive + TcpForwardFrontendConnection.this.sizeSend));
                }
                TcpForwardFrontendConnection.this.agent.removeConnection(TcpForwardFrontendConnection.this);
                if (TcpForwardFrontendConnection.this.partnerClosed) {
                    TcpForwardFrontendConnection.this.logger.trace("\u5bf9\u7aef\u5df2\u5173\u95ed\uff0c\u65e0\u9700\u901a\u77e5");
                } else {
                    TcpForwardFrontendConnection.this.logger.trace("notify: connection close");
                    TcpForwardFrontendConnection.this.agent.sendToRoute(new FeedbackPacket(TcpForwardFrontendConnection.this.id(), 1));
                }
                TcpForwardFrontendConnection.this.logger.debug("INACTIVE " + ctx.channel().toString());
            }

            protected void channelRead0(ChannelHandlerContext ctx, byte[] bs) throws Exception {
                DataPacket dataPacket = new DataPacket(TcpForwardFrontendConnection.this.id());
                dataPacket.setData(bs);
                TcpForwardFrontendConnection.this.logger.trace("notify: send data {}byte", (Object)bs.length);
                TcpForwardFrontendConnection.this.addBuffer(dataPacket);
                TcpForwardFrontendConnection.this.sizeSend += bs.length;
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                TcpForwardFrontendConnection.this.triggerSendToSwap();
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                TcpForwardFrontendConnection.this.logger.warn("\u8fde\u63a5\u672a\u77e5\u5f02\u5e38", cause);
                ctx.close();
            }
        }});
    }

    @Override
    public Boolean isRouteLocal() {
        return this.agent.isRouteLocal();
    }

    @Override
    protected IConnPacketListener newConnPacketListener() {
        return new IConnPacketListener(){

            @Override
            public void onPartnerConnectClose(AgentConnection agentConnection, FeedbackPacket feedback) {
                TcpForwardFrontendConnection.this.partnerClosed = true;
                Utils.closeOnFlush(TcpForwardFrontendConnection.this.channel());
            }

            @Override
            public void onPartnerConnectFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
                TcpForwardFrontendConnection.this.workSuccess = false;
                TcpForwardFrontendConnection.this.partnerClosed = true;
                TcpForwardFrontendConnection.this.channel().close();
            }

            @Override
            public void onPartnerConnectSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
                TcpForwardFrontendConnection.this.logger.trace("read data from channel");
                TcpForwardFrontendConnection.this.channel().read();
            }

            @Override
            public void onPartnerWriteFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
                TcpForwardFrontendConnection.this.workSuccess = false;
                TcpForwardFrontendConnection.this.channel().close();
            }

            @Override
            public void onPartnerWriteSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
                if (!TcpForwardFrontendConnection.this.triggerSendToSwap()) {
                    TcpForwardFrontendConnection.this.logger.trace("read data from channel");
                    TcpForwardFrontendConnection.this.channel().read();
                }
            }

            @Override
            public void receivePartnerData(AgentConnection agentConnection, DataPacket data) {
                TcpForwardFrontendConnection.this.sizeReceive += data.getData().length;
                TcpForwardFrontendConnection.this.channel().writeAndFlush((Object)data.getData()).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            TcpForwardFrontendConnection.this.logger.trace("notify: write data success");
                            TcpForwardFrontendConnection.this.agent.sendToRoute(new FeedbackPacket(TcpForwardFrontendConnection.this.id(), 5));
                        } else {
                            TcpForwardFrontendConnection.this.logger.trace("notify: write data failure");
                            TcpForwardFrontendConnection.this.agent.sendToRoute(new FeedbackPacket(TcpForwardFrontendConnection.this.id(), 4));
                            TcpForwardFrontendConnection.this.workSuccess = false;
                        }
                    }
                });
            }
        };
    }

    public final boolean triggerSendToSwap() {
        ChannelPacket one = this.dataQueue.poll();
        if (one != null) {
            this.agent.sendToRoute(one);
            return true;
        }
        return false;
    }
}

