/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine.impl.frontend;

import com.xdja.csagent.engine.Agent;
import com.xdja.csagent.engine.AgentConnection;
import com.xdja.csagent.engine.AgentMeta;
import com.xdja.csagent.engine.IConnPacketListener;
import com.xdja.csagent.engine.PortContext;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.engine.impl.custom.CustomHttpRequestDecoder;
import com.xdja.csagent.engine.packet.ChannelPacket;
import com.xdja.csagent.engine.packet.ConnectBegin;
import com.xdja.csagent.engine.packet.DataPacket;
import com.xdja.csagent.engine.packet.FeedbackPacket;
import com.xdja.csagent.engine.plugins.IConnectionPlugin;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.EncoderUtils;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLForwardFrontendConnection
extends AgentConnection {
    public final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PortContext portContext;
    private final Queue<ChannelPacket> dataQueue = new ConcurrentLinkedQueue<ChannelPacket>();
    private final CustomHttpRequestDecoder customHttpRequestDecoder;
    protected String requestUrl;
    private Agent matchAgent;
    private boolean isLastContent = false;
    private long timeConnect;
    private long sizeRequest = 0L;
    private long sizeResponse = 0L;
    private boolean workSuccess = false;
    private HashMap<String, Object> pluginContext = new HashMap();

    public URLForwardFrontendConnection(String id, Channel channel, PortContext portContext) {
        super(id, channel);
        this.portContext = portContext;
        this.customHttpRequestDecoder = new CustomHttpRequestDecoder();
        this.init(channel);
    }

    private boolean activeIntercept(ChannelHandlerContext ctx) {
        try {
            for (IConnectionPlugin plugin : this.getConnectionPlugins()) {
                if (!plugin.activeIntercept(ctx.channel(), this.matchAgent.getAgentMeta(), this.pluginContext)) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Connection Plugin Execute Error!", (Throwable)e);
        }
        return false;
    }

    public void addBuffer(ChannelPacket packet) {
        this.dataQueue.add(packet);
    }

    @Override
    public void applyNewConfig() {
        try {
            for (IConnectionPlugin plugin : this.getConnectionPlugins()) {
                plugin.applyNewConfig(this.channel(), this.matchAgent.getAgentMeta());
            }
        }
        catch (Exception e) {
            this.logger.error("Connection Plugin Execute Error!", (Throwable)e);
        }
    }

    protected boolean doHttpRequestFilter(ChannelHandlerContext ctx, String destHost, int destPort, String destPath) {
        try {
            for (IConnectionPlugin plugin : this.getConnectionPlugins()) {
                if (!plugin.httpRequestIntercept(ctx.channel(), this.matchAgent.getAgentMeta(), this.pluginContext, destHost, destPort, destPath)) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Connection Plugin Execute Error!", (Throwable)e);
        }
        return false;
    }

    private Agent getMatchAgentService(HttpRequest request) throws URISyntaxException {
        for (Agent one : this.portContext.getAgentService()) {
            String localContext = Utils.fixContextPath(one.getAgentMeta().getAgentContext());
            String actualPath = new URI(request.getUri()).getPath();
            if (!actualPath.startsWith(localContext)) continue;
            return one;
        }
        return null;
    }

    private String getReplacedPath(String uri, Agent one) throws URISyntaxException {
        String localContext = Utils.fixContextPath(one.getAgentMeta().getAgentContext());
        int offset = uri.indexOf(localContext);
        StringBuilder destPath = new StringBuilder(Utils.fixContextPath(one.getAgentMeta().getDestContext()));
        destPath.append(uri.substring(offset + localContext.length()));
        return destPath.toString();
    }

    private void init(Channel channel) {
        channel.pipeline().addLast(new ChannelHandler[]{this.customHttpRequestDecoder});
        channel.pipeline().addLast(new ChannelHandler[]{new ByteArrayEncoder()});
        channel.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<HttpObject>(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                URLForwardFrontendConnection.this.timeConnect = System.currentTimeMillis();
                ctx.read();
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                if (URLForwardFrontendConnection.this.matchAgent != null) {
                    URLForwardFrontendConnection.this.matchAgent.removeConnection(URLForwardFrontendConnection.this);
                    for (IConnectionPlugin plugin : URLForwardFrontendConnection.this.getConnectionPlugins()) {
                        plugin.onConnectOver(URLForwardFrontendConnection.this.matchAgent, URLForwardFrontendConnection.this.pluginContext, URLForwardFrontendConnection.this.requestUrl, URLForwardFrontendConnection.this.workSuccess, URLForwardFrontendConnection.this.timeConnect, System.currentTimeMillis(), new Long(URLForwardFrontendConnection.this.sizeRequest + URLForwardFrontendConnection.this.sizeResponse).intValue());
                    }
                    if (URLForwardFrontendConnection.this.partnerClosed) {
                        URLForwardFrontendConnection.this.logger.trace("\u5bf9\u7aef\u5df2\u5173\u95ed\uff0c\u65e0\u9700\u901a\u77e5");
                    } else {
                        URLForwardFrontendConnection.this.logger.trace("notify: connection close");
                        URLForwardFrontendConnection.this.matchAgent.sendToRoute(new FeedbackPacket(URLForwardFrontendConnection.this.id(), 1));
                    }
                }
                URLForwardFrontendConnection.this.logger.debug("INACTIVE " + ctx.channel().toString());
            }

            protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
                if (msg instanceof HttpRequest) {
                    URLForwardFrontendConnection.this.isLastContent = false;
                    HttpRequest request = (HttpRequest)msg;
                    URLForwardFrontendConnection.this.logger.debug("dest uri : {}", (Object)request.getUri());
                    URLForwardFrontendConnection.this.matchAgent = URLForwardFrontendConnection.this.getMatchAgentService(request);
                    if (URLForwardFrontendConnection.this.matchAgent != null) {
                        if (!URLForwardFrontendConnection.this.activeIntercept(ctx)) {
                            URLForwardFrontendConnection.this.matchAgent.addConnection(URLForwardFrontendConnection.this);
                            if (URLForwardFrontendConnection.this.matchAgent.getEngineParams().getHttpHeaderReplaceEnable().booleanValue()) {
                                for (Map.Entry<String, String> one : URLForwardFrontendConnection.this.matchAgent.getEngineParams().getHttpHeaderReplaceSet()) {
                                    request.headers().set(one.getKey(), (Object)one.getValue());
                                }
                            }
                            AgentMeta agentConfig = URLForwardFrontendConnection.this.matchAgent.getAgentMeta();
                            String destHost = agentConfig.getDestHost();
                            int destPort = agentConfig.getDestPort() > 0 ? agentConfig.getDestPort() : 80;
                            request.headers().set("Host", (Object)(Utils.extractHost(destHost) + ":" + destPort));
                            String destPath = URLForwardFrontendConnection.this.getReplacedPath(request.getUri(), URLForwardFrontendConnection.this.matchAgent);
                            request.setUri(destPath);
                            URLForwardFrontendConnection.this.requestUrl = destHost + ":" + destPort + destPath;
                            URLForwardFrontendConnection.this.logger.debug("will be forward to : {}", (Object)URLForwardFrontendConnection.this.requestUrl);
                            if (!URLForwardFrontendConnection.this.doHttpRequestFilter(ctx, destHost, destPort, destPath)) {
                                ConnectBegin connectBegin = new ConnectBegin(URLForwardFrontendConnection.this.id(), 2);
                                connectBegin.setHost(destHost);
                                connectBegin.setPort(destPort);
                                URLForwardFrontendConnection.this.addBuffer(connectBegin);
                                DataPacket data = new DataPacket(URLForwardFrontendConnection.this.id());
                                data.setLast(URLForwardFrontendConnection.this.isLastContent);
                                byte[] tmpData = EncoderUtils.encodeHttpRequest(request);
                                data.setData(tmpData);
                                URLForwardFrontendConnection.this.addBuffer(data);
                                URLForwardFrontendConnection.this.sizeRequest += tmpData.length;
                            }
                        } else {
                            URLForwardFrontendConnection.this.logger.debug("connection be activeIntercept!");
                        }
                    } else {
                        URLForwardFrontendConnection.this.logger.debug("dest uri match no agentService , will be close with 404!");
                        DefaultFullHttpResponse notFount = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
                        byte[] bytes = EncoderUtils.encodehttpResponse((HttpResponse)notFount);
                        ctx.writeAndFlush((Object)bytes).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    }
                } else if (msg instanceof LastHttpContent) {
                    URLForwardFrontendConnection.this.logger.trace("last request data read from channel");
                    URLForwardFrontendConnection.this.isLastContent = true;
                }
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                if (URLForwardFrontendConnection.this.matchAgent != null) {
                    byte[] bytes = URLForwardFrontendConnection.this.customHttpRequestDecoder.pollCache();
                    DataPacket data = new DataPacket(URLForwardFrontendConnection.this.id());
                    data.setData(bytes);
                    data.setLast(URLForwardFrontendConnection.this.isLastContent);
                    URLForwardFrontendConnection.this.addBuffer(data);
                    URLForwardFrontendConnection.this.sizeRequest += bytes.length;
                    URLForwardFrontendConnection.this.triggerSendToSwap();
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                URLForwardFrontendConnection.this.logger.warn("\u8fde\u63a5\u672a\u77e5\u5f02\u5e38", cause);
                ctx.close();
            }
        }});
    }

    @Override
    public Boolean isRouteLocal() {
        return this.matchAgent.isRouteLocal();
    }

    @Override
    protected IConnPacketListener newConnPacketListener() {
        return new IConnPacketListener(){

            @Override
            public void onPartnerConnectClose(AgentConnection agentConnection, FeedbackPacket feedback) {
                URLForwardFrontendConnection.this.partnerClosed = true;
                Utils.closeOnFlush(URLForwardFrontendConnection.this.channel());
            }

            @Override
            public void onPartnerConnectFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
                URLForwardFrontendConnection.this.logger.info("connect failure : " + URLForwardFrontendConnection.this.requestUrl);
                URLForwardFrontendConnection.this.partnerClosed = true;
                URLForwardFrontendConnection.this.channel().close();
            }

            @Override
            public void onPartnerConnectSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
                ChannelPacket request = URLForwardFrontendConnection.this.pollBuffer();
                URLForwardFrontendConnection.this.logger.trace("notify: send request header data");
                URLForwardFrontendConnection.this.matchAgent.sendToRoute(request);
            }

            @Override
            public void onPartnerWriteFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
                URLForwardFrontendConnection.this.channel().close();
            }

            @Override
            public void onPartnerWriteSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
                if (!URLForwardFrontendConnection.this.triggerSendToSwap()) {
                    URLForwardFrontendConnection.this.logger.trace("read data from channel");
                    URLForwardFrontendConnection.this.channel().read();
                }
            }

            @Override
            public void receivePartnerData(AgentConnection agentConnection, DataPacket packet) {
                URLForwardFrontendConnection.this.sizeResponse += packet.getData().length;
                final boolean last = packet.isLast();
                URLForwardFrontendConnection.this.channel().writeAndFlush((Object)packet.getData()).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            if (!last) {
                                URLForwardFrontendConnection.this.logger.trace("notify: write data success");
                                URLForwardFrontendConnection.this.matchAgent.sendToRoute(new FeedbackPacket(URLForwardFrontendConnection.this.id(), 5));
                            } else {
                                URLForwardFrontendConnection.this.logger.trace("last response data write success, will close");
                                URLForwardFrontendConnection.this.workSuccess = true;
                                future.channel().close();
                            }
                        } else {
                            URLForwardFrontendConnection.this.logger.debug("notify: write data failure", future.cause());
                            URLForwardFrontendConnection.this.matchAgent.sendToRoute(new FeedbackPacket(URLForwardFrontendConnection.this.id(), 4));
                        }
                    }
                });
            }
        };
    }

    public ChannelPacket pollBuffer() {
        return this.dataQueue.poll();
    }

    public final boolean triggerSendToSwap() {
        ChannelPacket one = this.dataQueue.poll();
        if (one != null) {
            this.matchAgent.sendToRoute(one);
            return true;
        }
        return false;
    }
}

