/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine;

import com.xdja.csagent.engine.AgentConnection;
import com.xdja.csagent.engine.AgentRoute;
import com.xdja.csagent.engine.IRoutePacketListener;
import com.xdja.csagent.engine.IWidget;
import com.xdja.csagent.engine.RouteSender;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.engine.bean.EngineParams;
import com.xdja.csagent.engine.consts.PacketSource;
import com.xdja.csagent.engine.impl.backend.HttpProxyBackendConnection;
import com.xdja.csagent.engine.impl.backend.TcpForwardBackendConnection;
import com.xdja.csagent.engine.impl.backend.UdpForwardBackendConnection;
import com.xdja.csagent.engine.packet.ChannelPacket;
import com.xdja.csagent.engine.packet.ConnectBegin;
import com.xdja.csagent.engine.packet.DataPacket;
import com.xdja.csagent.engine.packet.FeedbackPacket;
import com.xdja.csagent.engine.packet.Packet;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentBackend
implements IWidget {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentBackend.class);
    public final NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("AgentBackend-Connect"));
    protected final ScheduledExecutorService executorService;
    private final EngineParams engineParams;
    private ConcurrentMap<String, AgentConnection> connectionMap = new ConcurrentHashMap<String, AgentConnection>();
    private AgentRoute route;
    private final IRoutePacketListener routePacketListener;

    public AgentBackend(EngineParams engineParams) {
        this(Executors.newScheduledThreadPool(10, (ThreadFactory)new DefaultThreadFactory("AgentBackend")), engineParams);
    }

    public AgentBackend(ScheduledExecutorService executorService, EngineParams engineParams) {
        this.executorService = executorService;
        this.engineParams = engineParams;
        this.routePacketListener = new InnerPacketListener();
    }

    public IRoutePacketListener getRoutePacketListener() {
        return this.routePacketListener;
    }

    public int getConnectedCount() {
        return this.connectionMap.size();
    }

    public AgentConnection getConnection(String id) {
        return (AgentConnection)this.connectionMap.get(id);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isRunning() {
        return !this.executorService.isTerminated() || !this.nioEventLoopGroup.isTerminated();
    }

    @Override
    public void startup() throws Exception {
        LOGGER.info("Start AgentBackend ....");
        this.executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                for (AgentConnection one : AgentBackend.this.connectionMap.values()) {
                    Integer idleMillis = one instanceof UdpForwardBackendConnection ? AgentBackend.this.engineParams.getUdpSessionIdleMillis() : AgentBackend.this.engineParams.getConnectIdleMillis();
                    one.checkTimeout(idleMillis.intValue());
                }
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    private void createUdpConnection(DataPacket bean) {
        final DataPacket udpData = bean;
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.nioEventLoopGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(DatagramChannel ch) throws Exception {
                AgentBackend.this.initBackendConnect((Channel)ch, udpData, 5);
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        super.channelActive(ctx);
                        AgentConnection connection = (AgentConnection)AgentBackend.this.connectionMap.get(udpData.getChannelId());
                        if (connection != null) {
                            connection.onReceiveFromRoute(udpData);
                        }
                    }
                }});
            }
        })).bind(0).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    LOGGER.warn("udp bind for {} failure!!!", (Object)udpData.getChannelId());
                    LOGGER.debug("notify: connect failure");
                    FeedbackPacket bindFailure = new FeedbackPacket(udpData.getChannelId(), 6);
                    bindFailure.setSource(PacketSource.Backend);
                    bindFailure.setLocal(udpData.isLocal());
                    AgentBackend.this.route.send(bindFailure);
                    LOGGER.debug("close self channel");
                    future.channel().close();
                }
            }
        });
    }

    private void createTcpConnection(ConnectBegin bean) {
        final ConnectBegin connectBegin = bean;
        final String connectHost = Utils.extractHost(connectBegin.getHost());
        final Integer connectPort = connectBegin.getPort();
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                LOGGER.debug("try connect " + connectHost + ":" + connectPort);
                Bootstrap b = new Bootstrap();
                ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)AgentBackend.this.nioEventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    protected void initChannel(SocketChannel ch) throws Exception {
                        AgentBackend.this.initBackendConnect((Channel)ch, connectBegin, connectBegin.getAgentType());
                    }
                })).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)AgentBackend.this.engineParams.getConnectTimeoutMillis())).option(ChannelOption.AUTO_READ, (Object)false);
                b.connect(connectHost, connectPort.intValue()).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        if (!future.isSuccess()) {
                            LOGGER.warn("connect {}:{} failure!!!", (Object)connectHost, (Object)connectPort);
                            LOGGER.debug("notify: connect failure");
                            FeedbackPacket connectFailure = new FeedbackPacket(connectBegin.getChannelId(), 2);
                            connectFailure.setSource(PacketSource.Backend);
                            connectFailure.setLocal(connectBegin.isLocal());
                            AgentBackend.this.route.send(connectFailure);
                            LOGGER.debug("close self channel");
                            future.channel().close();
                        }
                    }
                });
            }
        });
    }

    private void initBackendConnect(Channel ch, ChannelPacket connectBegin, int agentType) throws Exception {
        if (Utils.EnableLogging) {
            ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO)});
        }
        final String channelId = connectBegin.getChannelId();
        AgentConnection conn = this.getAgentConnection(ch, channelId, connectBegin.isLocal(), agentType);
        this.connectionMap.put(conn.id(), conn);
        ch.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                AgentBackend.this.connectionMap.remove(channelId);
            }
        });
    }

    private AgentConnection getAgentConnection(Channel ch, String channelId, boolean local, int agentType) {
        AgentConnection conn;
        switch (agentType) {
            case 3: {
                conn = new HttpProxyBackendConnection(channelId, ch, this.getRouteSender(local));
                break;
            }
            case 4: {
                conn = new TcpForwardBackendConnection(channelId, ch, this.getRouteSender(local));
                break;
            }
            case 1: {
                conn = new TcpForwardBackendConnection(channelId, ch, this.getRouteSender(local));
                break;
            }
            case 5: {
                conn = new UdpForwardBackendConnection(channelId, ch, this.getRouteSender(local));
                break;
            }
            case 2: {
                conn = new HttpProxyBackendConnection(channelId, ch, this.getRouteSender(local));
                break;
            }
            default: {
                throw new IllegalArgumentException("AgentType : " + agentType);
            }
        }
        return conn;
    }

    private RouteSender getRouteSender(boolean isRouteLocal) {
        return new RouteSender(this.route, PacketSource.Backend, isRouteLocal);
    }

    class InnerPacketListener
    implements IRoutePacketListener {
        InnerPacketListener() {
        }

        @Override
        public boolean isReceive(Packet packet) {
            if (packet instanceof ChannelPacket) {
                ChannelPacket bean = (ChannelPacket)packet;
                return PacketSource.Backend != bean.getSource();
            }
            return false;
        }

        @Override
        public void init(AgentRoute route) {
            AgentBackend.this.route = route;
        }

        @Override
        public void close() {
            LOGGER.info("close AgentBackend begin");
            AgentBackend.this.executorService.shutdownNow();
            for (AgentConnection one : AgentBackend.this.connectionMap.values()) {
                one.close();
            }
            AgentBackend.this.nioEventLoopGroup.shutdownGracefully().awaitUninterruptibly();
            LOGGER.info("close AgentBackend over");
        }

        @Override
        public void onReceiveFromRoute(Packet packet, AgentRoute route) {
            final ChannelPacket bean = (ChannelPacket)packet;
            final AgentConnection connection = (AgentConnection)AgentBackend.this.connectionMap.get(bean.getChannelId());
            if (connection != null) {
                AgentBackend.this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        connection.onReceiveFromRoute(bean);
                    }
                });
            } else if (bean instanceof ConnectBegin) {
                AgentBackend.this.createTcpConnection((ConnectBegin)bean);
            } else if (bean instanceof DataPacket && ((DataPacket)bean).isUdp()) {
                AgentBackend.this.createUdpConnection((DataPacket)bean);
            } else {
                Utils.loggingIgnorePacket(bean, LOGGER);
            }
        }
    }
}

