/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine;

import com.google.common.collect.Sets;
import com.xdja.csagent.engine.Agent;
import com.xdja.csagent.engine.AgentConnection;
import com.xdja.csagent.engine.AgentMeta;
import com.xdja.csagent.engine.AgentRoute;
import com.xdja.csagent.engine.IRoutePacketListener;
import com.xdja.csagent.engine.IWidget;
import com.xdja.csagent.engine.PortContext;
import com.xdja.csagent.engine.PortListenManager;
import com.xdja.csagent.engine.RouteSender;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.engine.bean.EngineParams;
import com.xdja.csagent.engine.consts.AgentType;
import com.xdja.csagent.engine.consts.PacketSource;
import com.xdja.csagent.engine.impl.custom.CustomHttpRequestDecoder;
import com.xdja.csagent.engine.impl.custom.UdpConnectionCloseEvent;
import com.xdja.csagent.engine.impl.frontend.HttpProxyFrontendConnection;
import com.xdja.csagent.engine.impl.frontend.SocksFrontendConnection;
import com.xdja.csagent.engine.impl.frontend.TcpForwardFrontendConnection;
import com.xdja.csagent.engine.impl.frontend.URLForwardFrontendConnection;
import com.xdja.csagent.engine.impl.frontend.UdpForwardFrontendConnection;
import com.xdja.csagent.engine.packet.ChannelPacket;
import com.xdja.csagent.engine.packet.DataPacket;
import com.xdja.csagent.engine.packet.FeedbackPacket;
import com.xdja.csagent.engine.packet.Packet;
import com.xdja.csagent.engine.plugins.IConnectionPlugin;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.EncoderUtils;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class AgentFrontend
implements IWidget {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Agent> agentServiceMap = new HashMap<String, Agent>();
    private PortListenManager portListenManager;
    private EngineParams engineParams;
    private AgentRoute route;
    private final IRoutePacketListener routePacketListener;
    protected final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new DefaultThreadFactory("AgentFront-Timeout"));
    private final Set<IConnectionPlugin> connectionPluginSet = Sets.newConcurrentHashSet();

    public AgentFrontend(EngineParams engineParams) {
        this.portListenManager = new PortListenManager(engineParams, this);
        this.engineParams = engineParams;
        this.routePacketListener = new InnerPacketListener();
    }

    public void addConnectionPlugin(IConnectionPlugin connectionPlugin) {
        this.connectionPluginSet.add(connectionPlugin);
    }

    public void removeConnectionPlugin(IConnectionPlugin connectionPlugin) {
        this.connectionPluginSet.add(connectionPlugin);
    }

    public void addAgentService(AgentMeta agentMeta) throws Exception {
        if (!this.agentServiceMap.containsKey(agentMeta.getId())) {
            Agent agent = new Agent(this, agentMeta);
            this.portListenManager.registerListen(agent);
            this.agentServiceMap.put(agentMeta.getId(), agent);
        }
    }

    protected void channelInit(Channel channel, PortContext portContext) {
        int agentType = portContext.getAgentType();
        this.logger.trace("channel init : {}", (Object)AgentType.toDesc(agentType));
        if (5 == agentType) {
            this.udpChannelInit(channel, portContext.firstAgent());
        } else if (2 == agentType) {
            this.urlForwardChannelInit(channel, portContext);
        } else {
            final Agent agent = portContext.firstAgent();
            AgentConnection agentConnection = this.getAgentConnection(channel, agent);
            agentConnection.setConnectionPlugins(this.connectionPluginSet);
            agent.addConnection(agentConnection);
            final String connId = agentConnection.id();
            channel.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    super.channelInactive(ctx);
                    AgentFrontend.this.logger.trace("close connection {}", (Object)connId);
                    agent.removeConnection(connId);
                }
            }});
        }
    }

    private AgentConnection getAgentConnection(Channel channel, Agent agent) {
        AgentConnection connection;
        int agentType = agent.getAgentType();
        if (3 == agentType) {
            connection = new HttpProxyFrontendConnection(Utils.channelId(channel), channel, this.getRouteSender(agent.isRouteLocal()), agent);
        } else if (1 == agentType) {
            connection = new TcpForwardFrontendConnection(Utils.channelId(channel), channel, this.getRouteSender(agent.isRouteLocal()), agent);
        } else if (4 == agentType) {
            connection = new SocksFrontendConnection(Utils.channelId(channel), channel, this.getRouteSender(agent.isRouteLocal()), agent);
        } else if (2 == agentType) {
            connection = new URLForwardFrontendConnection(Utils.channelId(channel), channel, this.getRouteSender(agent.isRouteLocal()), agent);
        } else {
            throw new IllegalArgumentException("AgentType : " + agentType);
        }
        return connection;
    }

    private void urlForwardChannelInit(Channel channel, final PortContext portContext) {
        channel.pipeline().addLast("customHttpRequestDecoder", (ChannelHandler)new CustomHttpRequestDecoder());
        channel.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<HttpObject>(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                super.channelActive(ctx);
                ctx.read();
            }

            protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
                if (msg instanceof HttpRequest) {
                    HttpRequest request = (HttpRequest)msg;
                    AgentFrontend.this.logger.debug("dest uri : {}", (Object)request.getUri());
                    final Agent matchAgent = AgentFrontend.getMatchAgentService(request, portContext.getAgents());
                    if (matchAgent != null) {
                        AgentConnection connection = AgentFrontend.this.getAgentConnection(ctx.channel(), matchAgent);
                        matchAgent.addConnection(connection);
                        final String connId = connection.id();
                        ctx.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                                super.channelInactive(ctx);
                                AgentFrontend.this.logger.trace("close connection {}", (Object)connId);
                                matchAgent.removeConnection(connId);
                            }
                        }});
                        ctx.pipeline().remove((ChannelHandler)this);
                        ctx.fireChannelRead((Object)msg);
                    } else {
                        AgentFrontend.this.logger.debug("dest uri match no agentService , will be close with 404!");
                        DefaultFullHttpResponse notFount = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND, Unpooled.wrappedBuffer((byte[])"FILE NOT FOUND !".getBytes()));
                        byte[] bytes = EncoderUtils.encodehttpResponse((HttpResponse)notFount);
                        ctx.writeAndFlush((Object)bytes).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    }
                }
            }
        }});
    }

    private static Agent getMatchAgentService(HttpRequest request, List<Agent> agents) throws URISyntaxException {
        for (Agent one : agents) {
            String localContext = Utils.fixContextPath(one.getAgentMeta().getAgentContext());
            String actualPath = new URI(request.getUri()).getPath();
            if (!actualPath.startsWith(localContext)) continue;
            return one;
        }
        return null;
    }

    private void udpChannelInit(Channel channel, final Agent udpAgent) {
        channel.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<DatagramPacket>(){

            protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
                String sourceIp = ((InetSocketAddress)msg.sender()).getAddress().getHostAddress();
                int sourcePort = ((InetSocketAddress)msg.sender()).getPort();
                int localPort = ((InetSocketAddress)ctx.channel().localAddress()).getPort();
                String destIp = udpAgent.getAgentMeta().getDestHost();
                int destPort = udpAgent.getAgentMeta().getDestPort();
                String connectId = "UDP#" + sourceIp + ":" + sourcePort + "#" + localPort + "#" + destIp + ":" + destPort;
                if (!udpAgent.containsConnection(connectId).booleanValue()) {
                    UdpForwardFrontendConnection connection = new UdpForwardFrontendConnection(connectId, ctx.channel(), AgentFrontend.this.getRouteSender(udpAgent.isRouteLocal()), udpAgent, (InetSocketAddress)msg.sender());
                    connection.setConnectionPlugins(AgentFrontend.this.connectionPluginSet);
                    udpAgent.addConnection(connection);
                }
                ((UdpForwardFrontendConnection)udpAgent.getConnection(connectId)).onReceiveDatagramPacket(msg);
            }

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt instanceof UdpConnectionCloseEvent) {
                    String id = ((UdpConnectionCloseEvent)evt).getConnectionId();
                    udpAgent.removeConnection(id);
                }
            }
        }});
    }

    private RouteSender getRouteSender(boolean routeLocal) {
        return new RouteSender(this.route, PacketSource.Frontend, routeLocal);
    }

    public Agent getAgentService(String id) {
        return this.agentServiceMap.get(id);
    }

    public EngineParams getEngineParams() {
        return this.engineParams;
    }

    public Set<String> getAgentServiceIds() {
        return this.agentServiceMap.keySet();
    }

    public IRoutePacketListener getRoutePacketListener() {
        return this.routePacketListener;
    }

    public void removeAgentService(String id) throws Exception {
        Agent agent = this.agentServiceMap.get(id);
        Assert.notNull((Object)agent, (String)("id\u4e3a" + id + "\u7684\u4ee3\u7406\u670d\u52a1\u4e0d\u5b58\u5728"));
        agent.closeAllConnection();
        this.portListenManager.unregisterListen(agent);
        this.agentServiceMap.remove(id);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isRunning() {
        return this.portListenManager.isRunning();
    }

    @Override
    public void startup() throws Exception {
        this.logger.info("Start AgentFrontend....");
        this.portListenManager.startup();
        this.executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    for (Agent one : AgentFrontend.this.agentServiceMap.values()) {
                        one.checkConnectionTimeout();
                    }
                }
                catch (Exception e) {
                    AgentFrontend.this.logger.error("AgentFrontend timeout check error! ", (Throwable)e);
                }
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        this.logger.debug("Start AgentFrontend Over!!!");
    }

    public void updateAgentMeta(AgentMeta newCfg) throws Exception {
        Agent agent = this.agentServiceMap.get(newCfg.getId());
        if (agent != null) {
            boolean needRestart = false;
            if (this.agentPortChange(newCfg, agent) || this.agentTypeChange(newCfg, agent) || this.routeLocalChange(newCfg, agent)) {
                needRestart = true;
            }
            agent.resetMeta(newCfg);
            if (needRestart) {
                agent.closeAllConnection();
                this.portListenManager.unregisterListen(agent);
                this.portListenManager.registerListen(agent);
            } else {
                agent.applyNewConfig();
            }
        }
    }

    private boolean routeLocalChange(AgentMeta newCfg, Agent agent) {
        return !agent.isRouteLocal().equals(newCfg.isRouteLocal());
    }

    private boolean agentTypeChange(AgentMeta newCfg, Agent agent) {
        return !agent.getAgentType().equals(newCfg.getAgentType());
    }

    private boolean agentPortChange(AgentMeta newCfg, Agent agent) {
        return !agent.getAgentPort().equals(newCfg.getAgentPort());
    }

    class InnerPacketListener
    implements IRoutePacketListener {
        InnerPacketListener() {
        }

        @Override
        public boolean isReceive(Packet bean) {
            if (bean instanceof ChannelPacket) {
                return ((ChannelPacket)bean).getSource() != PacketSource.Frontend;
            }
            return false;
        }

        @Override
        public void init(AgentRoute route) {
            Assert.isNull((Object)AgentFrontend.this.route);
            AgentFrontend.this.route = route;
        }

        @Override
        public void close() {
            AgentFrontend.this.logger.info("close AgentFrontend begin");
            AgentFrontend.this.executorService.shutdownNow();
            for (Object one : AgentFrontend.this.connectionPluginSet) {
                one.onPluginDestroy();
            }
            for (Object one : AgentFrontend.this.agentServiceMap.values()) {
                ((Agent)one).closeAllConnection();
            }
            AgentFrontend.this.portListenManager.shutdown();
            AgentFrontend.this.logger.debug("close AgentFrontend over");
        }

        @Override
        public void onReceiveFromRoute(Packet packet, AgentRoute route) {
            ChannelPacket bean = (ChannelPacket)packet;
            for (Agent one : AgentFrontend.this.agentServiceMap.values()) {
                if (!one.containsConnection(bean.getChannelId()).booleanValue()) continue;
                one.onReceiveFromRoute(bean);
                return;
            }
            if (bean instanceof DataPacket && ((DataPacket)bean).isUdp()) {
                FeedbackPacket feedbackPacket = new FeedbackPacket(bean.getChannelId(), 1);
                feedbackPacket.setLocal(bean.isLocal());
                feedbackPacket.setSource(PacketSource.Frontend);
                route.send(feedbackPacket);
            } else {
                Utils.loggingIgnorePacket(bean, AgentFrontend.this.logger);
            }
        }
    }
}

