/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine;

import com.xdja.csagent.dataswap.core.SwapConfig;
import com.xdja.csagent.dataswap.core.SwapManager;
import com.xdja.csagent.dataswap.core.SwapManagerFactory;
import com.xdja.csagent.engine.Agent;
import com.xdja.csagent.engine.AgentBackend;
import com.xdja.csagent.engine.AgentFrontend;
import com.xdja.csagent.engine.AgentMeta;
import com.xdja.csagent.engine.AgentRoute;
import com.xdja.csagent.engine.IRoutePacketListener;
import com.xdja.csagent.engine.IWidget;
import com.xdja.csagent.engine.bean.DataSwapStatus;
import com.xdja.csagent.engine.bean.EngineParams;
import com.xdja.csagent.engine.plugins.IConnectionPlugin;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSEngine
implements IWidget {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SwapManager swapManager;
    private AgentRoute agentRoute;
    private AgentFrontend agentFrontend;
    private AgentBackend agentBackend;
    private final SwapConfig swapConfig = new SwapConfig();
    private final EngineParams engineParams = new EngineParams();

    public int connectionCountUnderAgent(String id) {
        this.checkStartup();
        Agent agentService = this.agentFrontend.getAgentService(id);
        if (agentService != null) {
            return agentService.getConnectedCount();
        }
        return 0;
    }

    public DataSwapStatus getSwapStatus() {
        DataSwapStatus rst = new DataSwapStatus();
        if (this.swapManager != null && this.swapManager.isSwapConnected()) {
            rst.setConnected(true);
            rst.setMode(this.swapManager.getMode());
            rst.setLocalAddress(this.swapManager.localConnInfo());
            rst.setRemoteAddress(this.swapManager.remoteConnInfo());
        } else {
            rst.setConnected(false);
            rst.setMode("None");
            rst.setLocalAddress("\u65e0");
            rst.setRemoteAddress("\u65e0");
        }
        return rst;
    }

    public void addAgent(AgentMeta agentMeta) throws Exception {
        this.logger.info("start agent : {}", (Object)agentMeta.toString());
        this.checkStartup();
        this.agentFrontend.addAgentService(agentMeta);
    }

    private void checkStartup() {
        if (this.agentFrontend == null || this.agentRoute == null) {
            throw new IllegalStateException("CSEngine is not startup");
        }
    }

    public void removeAgent(String agentId) throws Exception {
        this.checkStartup();
        this.agentFrontend.removeAgentService(agentId);
    }

    public void addRoutePacketListener(IRoutePacketListener listener) {
        this.checkStartup();
        this.agentRoute.addPacketListener(listener);
    }

    public void removeRoutePacketListener(IRoutePacketListener listener) {
        this.checkStartup();
        this.agentRoute.removePacketListener(listener);
    }

    public void addConnectionPlugin(IConnectionPlugin connectionPlugin) {
        this.checkStartup();
        this.agentFrontend.addConnectionPlugin(connectionPlugin);
    }

    public void removeConnectionPlugin(IConnectionPlugin connectionPlugin) {
        this.checkStartup();
        this.agentFrontend.removeConnectionPlugin(connectionPlugin);
    }

    public SwapConfig getSwapConfig() {
        return this.swapConfig;
    }

    public EngineParams getEngineParams() {
        return this.engineParams;
    }

    @Override
    public void startup() throws Exception {
        this.logger.info("start CSEngine");
        this.swapManager = SwapManagerFactory.getSwapManager((SwapConfig)this.swapConfig);
        this.swapManager.startSwap();
        this.agentRoute = new AgentRoute(this.swapManager);
        this.agentRoute.startup();
        this.agentBackend = new AgentBackend(this.engineParams);
        this.agentBackend.startup();
        this.agentRoute.addPacketListener(this.agentBackend.getRoutePacketListener());
        this.agentFrontend = new AgentFrontend(this.engineParams);
        this.agentFrontend.startup();
        this.agentRoute.addPacketListener(this.agentFrontend.getRoutePacketListener());
    }

    @Override
    public void shutdown() {
        for (IWidget widget : Arrays.asList(this.agentFrontend, this.agentRoute, this.agentBackend)) {
            if (widget == null) continue;
            try {
                widget.shutdown();
            }
            catch (Exception e) {
                this.logger.error("Shutdown {} error", (Object)widget.getClass().getSimpleName(), (Object)e);
            }
        }
        try {
            if (this.swapManager != null) {
                this.swapManager.stopSwap();
                this.swapManager = null;
            }
        }
        catch (Exception e) {
            this.logger.error("Shutdown SwapManager error", (Throwable)e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.agentFrontend != null && this.agentRoute != null && this.agentBackend != null && this.swapManager != null;
    }

    public boolean hasAgent(String agentId) {
        this.checkStartup();
        return this.agentFrontend.getAgentService(agentId) != null;
    }

    public void updateAgentMeta(AgentMeta meta) throws Exception {
        this.checkStartup();
        this.agentFrontend.updateAgentMeta(meta);
    }

    public AgentMeta getAgentMeta(String agentId) {
        this.checkStartup();
        Agent agentService = this.agentFrontend.getAgentService(agentId);
        if (agentService != null) {
            return agentService.getAgentMeta();
        }
        return null;
    }

    public void reApplyAgentMeta(String agentId) {
        this.checkStartup();
        Agent agentService = this.agentFrontend.getAgentService(agentId);
        if (agentService != null) {
            agentService.applyNewConfig();
        }
    }
}

