/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine;

import com.google.common.collect.Lists;
import com.xdja.csagent.engine.Agent;
import com.xdja.csagent.engine.AgentPort;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortContext {
    public final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AgentPort port;
    private final int agentType;
    private Channel bindChannel;
    private List<Agent> agents = Lists.newArrayList();

    public PortContext(AgentPort port, int agentType) {
        this.port = port;
        this.agentType = agentType;
    }

    public int getAgentType() {
        return this.agentType;
    }

    public void addAgentService(Agent agent) {
        this.agents.add(agent);
    }

    public Agent firstAgent() {
        return this.agents.get(0);
    }

    public List<Agent> getAgents() {
        return this.agents;
    }

    public AgentPort getPort() {
        return this.port;
    }

    public void bind(ServerBootstrap tcpBootstrap, Bootstrap udpBootstrap) {
        this.bindChannel = this.doBind(tcpBootstrap, udpBootstrap);
    }

    protected Channel doBind(ServerBootstrap tcpBootstrap, Bootstrap udpBootstrap) {
        if (AgentPort.Protocol.TCP == this.port.getProtocol()) {
            return tcpBootstrap.bind(this.port.getPort()).syncUninterruptibly().channel();
        }
        return udpBootstrap.bind(this.port.getPort()).syncUninterruptibly().channel();
    }

    public boolean hasAgentService() {
        return !this.agents.isEmpty();
    }

    public void removeAgentService(Agent agent) {
        this.agents.remove(agent);
    }

    public void unbind() {
        this.bindChannel.close().syncUninterruptibly();
    }
}

