/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine;

import com.xdja.csagent.engine.Agent;
import com.xdja.csagent.engine.AgentFrontend;
import com.xdja.csagent.engine.AgentPort;
import com.xdja.csagent.engine.IWidget;
import com.xdja.csagent.engine.PortContext;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.engine.bean.EngineParams;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortListenManager
implements IWidget {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EngineParams engineParams;
    private final AgentFrontend agentFrontend;
    private ServerBootstrap tcpBootstrap;
    private Bootstrap udpBootstrap;
    private ConcurrentMap<AgentPort, PortContext> portContextMap = new ConcurrentHashMap<AgentPort, PortContext>();

    public PortListenManager(EngineParams engineParams, AgentFrontend agentFrontend) {
        this.engineParams = engineParams;
        this.agentFrontend = agentFrontend;
    }

    public Set<AgentPort> getListenPorts() {
        return this.portContextMap.keySet();
    }

    public PortContext getPortContext(Integer port) {
        return (PortContext)this.portContextMap.get(port);
    }

    public void onChannelInit(AgentPort port, Channel channel) {
        this.logger.debug("initChannel : {}", (Object)channel.toString());
        if (Utils.EnableLogging) {
            channel.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO)});
        }
        if (!this.portContextMap.containsKey(port)) {
            this.logger.warn("\u7aef\u53e3{}\u65e0\u670d\u52a1\uff1f", (Object)port);
            channel.close();
            return;
        }
        PortContext portContext = (PortContext)this.portContextMap.get(port);
        this.agentFrontend.channelInit(channel, portContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerListen(Agent agent) throws Exception {
        AgentPort agentPort = new AgentPort(5 == agent.getAgentType() ? AgentPort.Protocol.UDP : AgentPort.Protocol.TCP, agent.getAgentPort());
        if (this.portContextMap.containsKey(agentPort)) {
            PortContext portContext = (PortContext)this.portContextMap.get(agentPort);
            if (2 != portContext.getAgentType()) throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7aef\u53e3\u5171\u4eab!");
            portContext.addAgentService(agent);
            return;
        } else {
            PortContext portContext = new PortContext(agentPort, agent.getAgentType());
            portContext.addAgentService(agent);
            portContext.bind(this.tcpBootstrap, this.udpBootstrap);
            this.portContextMap.put(agentPort, portContext);
        }
    }

    @Override
    public void shutdown() {
        for (PortContext one : this.portContextMap.values()) {
            one.unbind();
        }
        this.portContextMap.clear();
        if (this.tcpBootstrap != null) {
            this.tcpBootstrap.group().shutdownGracefully().awaitUninterruptibly();
            this.tcpBootstrap.childGroup().shutdownGracefully().awaitUninterruptibly();
            this.tcpBootstrap = null;
        }
        if (this.udpBootstrap != null && !this.udpBootstrap.group().isShutdown()) {
            this.udpBootstrap.group().shutdownGracefully().awaitUninterruptibly();
        }
        this.logger.info("Stop Listen Service Success!!!");
    }

    @Override
    public boolean isRunning() {
        return this.tcpBootstrap != null && this.udpBootstrap != null;
    }

    @Override
    public void startup() throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory("AgentFrontend-BOSS"));
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("AgentFrontend-WORKER"));
        this.tcpBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                int port = ch.localAddress().getPort();
                PortListenManager.this.onChannelInit(new AgentPort(AgentPort.Protocol.TCP, port), (Channel)ch);
            }
        }).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)10000)).option(ChannelOption.SO_TIMEOUT, (Object)5000)).childOption(ChannelOption.AUTO_READ, (Object)false);
        this.udpBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)workerGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(DatagramChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        InetSocketAddress localAddress = (InetSocketAddress)ctx.channel().localAddress();
                        PortListenManager.this.onChannelInit(new AgentPort(AgentPort.Protocol.UDP, localAddress.getPort()), ctx.channel());
                        ctx.pipeline().remove((ChannelHandler)this);
                        super.channelRead(ctx, msg);
                    }
                }});
            }
        });
    }

    public void unregisterListen(Agent agent) {
        AgentPort agentPort = new AgentPort(5 == agent.getAgentType() ? AgentPort.Protocol.UDP : AgentPort.Protocol.TCP, agent.getAgentPort());
        if (this.portContextMap.containsKey(agentPort)) {
            PortContext portContext = (PortContext)this.portContextMap.get(agentPort);
            portContext.removeAgentService(agent);
            if (!portContext.hasAgentService()) {
                this.portContextMap.remove(agentPort);
                portContext.unbind();
            }
        } else {
            this.logger.warn("\u627e\u4e0d\u5230\u8981unregister\u7684port,agentService:{},port:{}", (Object)agent.getAgentMeta().getId(), (Object)agentPort);
        }
    }
}

