/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine;

import com.xdja.csagent.engine.AgentRoute;
import com.xdja.csagent.engine.consts.PacketSource;
import com.xdja.csagent.engine.packet.ChannelPacket;

public class RouteSender {
    private long latestSendTime;
    private final boolean isRouteLocal;
    private final PacketSource packetSource;
    private final AgentRoute route;

    public RouteSender(AgentRoute route, PacketSource packetSource, boolean isRouteLocal) {
        this.route = route;
        this.isRouteLocal = isRouteLocal;
        this.packetSource = packetSource;
        this.latestSendTime = System.currentTimeMillis();
    }

    public long getLatestSendTime() {
        return this.latestSendTime;
    }

    public boolean sendToRoute(ChannelPacket one) {
        this.latestSendTime = System.currentTimeMillis();
        one.setLocal(this.isRouteLocal);
        one.setSource(this.packetSource);
        if (this.route != null && this.route.isAvailable(one)) {
            return this.route.send(one);
        }
        return false;
    }
}

