/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine.impl.backend;

import com.xdja.csagent.engine.AgentConnection;
import com.xdja.csagent.engine.IConnPacketListener;
import com.xdja.csagent.engine.RouteSender;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.engine.impl.custom.CustomHttpResponseDecoder;
import com.xdja.csagent.engine.packet.ChannelPacket;
import com.xdja.csagent.engine.packet.DataPacket;
import com.xdja.csagent.engine.packet.FeedbackPacket;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.handler.codec.http.EncoderUtils;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyBackendConnection
extends AgentConnection {
    private final Queue<ChannelPacket> dataQueue = new ConcurrentLinkedQueue<ChannelPacket>();
    private final CustomHttpResponseDecoder customHttpResponseDecoder;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean isLastContent;

    public HttpProxyBackendConnection(String id, Channel channel, RouteSender routeSender) {
        super(id, channel, routeSender);
        this.customHttpResponseDecoder = new CustomHttpResponseDecoder();
        this.init(channel);
    }

    public void addBuffer(ChannelPacket packet) {
        this.dataQueue.add(packet);
    }

    @Override
    public void applyNewConfig() {
    }

    @Override
    public void close() {
        this.channel().close().syncUninterruptibly();
    }

    private void init(Channel channel) {
        channel.pipeline().addLast(new ChannelHandler[]{this.customHttpResponseDecoder});
        channel.pipeline().addLast(new ChannelHandler[]{new ByteArrayEncoder()});
        channel.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<HttpObject>(){

            public final void channelActive(ChannelHandlerContext ctx) throws Exception {
                HttpProxyBackendConnection.this.logger.trace("notify: connect success");
                HttpProxyBackendConnection.this.routeSender.sendToRoute(new FeedbackPacket(HttpProxyBackendConnection.this.id(), 3));
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                if (HttpProxyBackendConnection.this.partnerClosed) {
                    HttpProxyBackendConnection.this.logger.trace("\u5bf9\u7aef\u5df2\u5173\u95ed\uff0c\u65e0\u9700\u901a\u77e5");
                } else {
                    HttpProxyBackendConnection.this.logger.trace("notify: connection close");
                    HttpProxyBackendConnection.this.routeSender.sendToRoute(new FeedbackPacket(HttpProxyBackendConnection.this.id(), 1));
                }
                HttpProxyBackendConnection.this.logger.debug("INACTIVE " + ctx.channel().toString());
            }

            public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
                if (msg instanceof HttpResponse) {
                    HttpProxyBackendConnection.this.isLastContent = false;
                    byte[] bs = EncoderUtils.encodehttpResponse((HttpResponse)msg);
                    DataPacket bean = new DataPacket(HttpProxyBackendConnection.this.id());
                    bean.setData(bs);
                    bean.setLast(HttpProxyBackendConnection.this.isLastContent);
                    HttpProxyBackendConnection.this.addBuffer(bean);
                } else if (msg instanceof LastHttpContent) {
                    HttpProxyBackendConnection.this.isLastContent = true;
                    HttpProxyBackendConnection.this.logger.trace("the data is last");
                }
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                byte[] bytes = HttpProxyBackendConnection.this.customHttpResponseDecoder.pollCache();
                DataPacket data = new DataPacket(HttpProxyBackendConnection.this.id());
                data.setData(bytes);
                data.setLast(HttpProxyBackendConnection.this.isLastContent);
                HttpProxyBackendConnection.this.addBuffer(data);
                HttpProxyBackendConnection.this.triggerSendToSwap();
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                HttpProxyBackendConnection.this.logger.warn("\u8fde\u63a5\u672a\u77e5\u5f02\u5e38", cause);
                ctx.close();
            }
        }});
    }

    @Override
    protected IConnPacketListener newConnPacketListener() {
        return new IConnPacketListener(){

            @Override
            public void onPartnerConnectClose(AgentConnection agentConnection, FeedbackPacket feedback) {
                HttpProxyBackendConnection.this.partnerClosed = true;
                Utils.closeOnFlush(HttpProxyBackendConnection.this.channel());
            }

            @Override
            public void onPartnerConnectFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
            }

            @Override
            public void onPartnerConnectSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
            }

            @Override
            public void onPartnerWriteFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
                HttpProxyBackendConnection.this.channel().close();
            }

            @Override
            public void onPartnerWriteSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
                if (!HttpProxyBackendConnection.this.triggerSendToSwap()) {
                    HttpProxyBackendConnection.this.logger.trace("read data from channel");
                    HttpProxyBackendConnection.this.channel().read();
                }
            }

            @Override
            public void receivePartnerData(AgentConnection agentConnection, DataPacket data) {
                final boolean last = data.isLast();
                HttpProxyBackendConnection.this.channel().writeAndFlush((Object)data.getData()).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        if (future.isSuccess()) {
                            if (last) {
                                HttpProxyBackendConnection.this.logger.trace("last request data write success, will read response");
                                HttpProxyBackendConnection.this.channel().read();
                            } else {
                                HttpProxyBackendConnection.this.logger.trace("notify: write data success");
                                HttpProxyBackendConnection.this.routeSender.sendToRoute(new FeedbackPacket(HttpProxyBackendConnection.this.id(), 5));
                            }
                        } else {
                            HttpProxyBackendConnection.this.logger.warn("notify: write data failure", future.cause());
                            HttpProxyBackendConnection.this.routeSender.sendToRoute(new FeedbackPacket(HttpProxyBackendConnection.this.id(), 4));
                        }
                    }
                });
            }
        };
    }

    public ChannelPacket pollBuffer() {
        return this.dataQueue.poll();
    }

    public final boolean triggerSendToSwap() {
        ChannelPacket one = this.dataQueue.poll();
        if (one != null) {
            this.routeSender.sendToRoute(one);
            return true;
        }
        return false;
    }
}

