/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine.impl.backend;

import com.xdja.csagent.engine.AgentConnection;
import com.xdja.csagent.engine.IConnPacketListener;
import com.xdja.csagent.engine.RouteSender;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.engine.packet.ChannelPacket;
import com.xdja.csagent.engine.packet.DataPacket;
import com.xdja.csagent.engine.packet.FeedbackPacket;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpForwardBackendConnection
extends AgentConnection {
    private final Queue<ChannelPacket> dataQueue = new ConcurrentLinkedQueue<ChannelPacket>();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public TcpForwardBackendConnection(String id, Channel channel, RouteSender agentBackend) {
        super(id, channel, agentBackend);
        this.init(channel);
    }

    @Override
    public void close() {
        this.channel().close().syncUninterruptibly();
    }

    public void addBuffer(ChannelPacket packet) {
        this.dataQueue.add(packet);
    }

    @Override
    public void applyNewConfig() {
    }

    private void init(Channel channel) {
        channel.pipeline().addLast(new ChannelHandler[]{new ByteArrayDecoder()});
        channel.pipeline().addLast(new ChannelHandler[]{new ByteArrayEncoder()});
        channel.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<byte[]>(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                super.channelActive(ctx);
                TcpForwardBackendConnection.this.logger.trace("notify: connect success!");
                TcpForwardBackendConnection.this.routeSender.sendToRoute(new FeedbackPacket(TcpForwardBackendConnection.this.id(), 3));
                ctx.read();
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                super.channelInactive(ctx);
                if (TcpForwardBackendConnection.this.partnerClosed) {
                    TcpForwardBackendConnection.this.logger.trace("\u5bf9\u7aef\u5df2\u5173\u95ed\uff0c\u65e0\u9700\u901a\u77e5");
                } else {
                    TcpForwardBackendConnection.this.logger.trace("notify: connection close");
                    TcpForwardBackendConnection.this.routeSender.sendToRoute(new FeedbackPacket(TcpForwardBackendConnection.this.id(), 1));
                }
                TcpForwardBackendConnection.this.logger.debug("INACTIVE " + ctx.channel().toString());
            }

            public void channelRead0(ChannelHandlerContext ctx, byte[] msg) {
                DataPacket bean = new DataPacket(TcpForwardBackendConnection.this.id());
                bean.setData(msg);
                TcpForwardBackendConnection.this.logger.trace("read data from channel");
                TcpForwardBackendConnection.this.addBuffer(bean);
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                TcpForwardBackendConnection.this.triggerSendToSwap();
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                TcpForwardBackendConnection.this.logger.warn("\u8fde\u63a5\u672a\u77e5\u5f02\u5e38", cause);
                ctx.close();
            }
        }});
    }

    @Override
    protected IConnPacketListener newConnPacketListener() {
        return new IConnPacketListener(){

            @Override
            public void onPartnerConnectClose(AgentConnection agentConnection, FeedbackPacket feedback) {
                TcpForwardBackendConnection.this.partnerClosed = true;
                Utils.closeOnFlush(TcpForwardBackendConnection.this.channel());
            }

            @Override
            public void onPartnerConnectFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
            }

            @Override
            public void onPartnerConnectSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
            }

            @Override
            public void onPartnerWriteFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
                TcpForwardBackendConnection.this.channel().close();
            }

            @Override
            public void onPartnerWriteSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
                if (!TcpForwardBackendConnection.this.triggerSendToSwap()) {
                    TcpForwardBackendConnection.this.logger.trace("read data from channel");
                    TcpForwardBackendConnection.this.channel().read();
                }
            }

            @Override
            public void receivePartnerData(AgentConnection agentConnection, DataPacket data) {
                TcpForwardBackendConnection.this.channel().writeAndFlush((Object)data.getData()).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        if (future.isSuccess()) {
                            TcpForwardBackendConnection.this.logger.trace("notify: write data success");
                            TcpForwardBackendConnection.this.routeSender.sendToRoute(new FeedbackPacket(TcpForwardBackendConnection.this.id(), 5));
                        } else {
                            TcpForwardBackendConnection.this.logger.trace("notify: write data failure", future.cause());
                            TcpForwardBackendConnection.this.routeSender.sendToRoute(new FeedbackPacket(TcpForwardBackendConnection.this.id(), 4));
                        }
                    }
                });
            }
        };
    }

    public final boolean triggerSendToSwap() {
        ChannelPacket one = this.dataQueue.poll();
        if (one != null) {
            this.routeSender.sendToRoute(one);
            return true;
        }
        return false;
    }
}

