/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine.impl.backend;

import com.xdja.csagent.engine.AgentConnection;
import com.xdja.csagent.engine.IConnPacketListener;
import com.xdja.csagent.engine.RouteSender;
import com.xdja.csagent.engine.packet.DataPacket;
import com.xdja.csagent.engine.packet.FeedbackPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpForwardBackendConnection
extends AgentConnection {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InetSocketAddress destAddress;

    public UdpForwardBackendConnection(String id, Channel channel, RouteSender agentBackend) {
        super(id, channel, agentBackend);
        String[] sharpArr = id.split("#");
        String[] addArr = sharpArr[3].split(":");
        this.destAddress = new InetSocketAddress(addArr[0], Integer.parseInt(addArr[1]));
        this.init(channel);
    }

    private void init(Channel channel) {
        channel.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<DatagramPacket>(){

            protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
                UdpForwardBackendConnection.this.logger.trace("read udp package from {},local is {}", (Object)((InetSocketAddress)msg.sender()).toString(), (Object)((InetSocketAddress)msg.recipient()).toString());
                DataPacket packet = new DataPacket(UdpForwardBackendConnection.this.id(), true);
                byte[] bs = new byte[((ByteBuf)msg.content()).readableBytes()];
                ((ByteBuf)msg.content()).readBytes(bs);
                packet.setData(bs);
                UdpForwardBackendConnection.this.routeSender.sendToRoute(packet);
            }
        }});
    }

    @Override
    public void applyNewConfig() {
    }

    @Override
    public void close() {
        this.channel().close().syncUninterruptibly();
    }

    @Override
    protected IConnPacketListener newConnPacketListener() {
        return new IConnPacketListener(){

            @Override
            public void onPartnerConnectClose(AgentConnection agentConnection, FeedbackPacket feedback) {
                agentConnection.close();
            }

            @Override
            public void onPartnerConnectFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
            }

            @Override
            public void onPartnerConnectSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
            }

            @Override
            public void onPartnerWriteFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
            }

            @Override
            public void onPartnerWriteSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
            }

            @Override
            public void receivePartnerData(AgentConnection agentConnection, DataPacket packet) {
                UdpForwardBackendConnection.this.logger.trace("receive partner udp  DataPacket, from {} forward to {}", (Object)UdpForwardBackendConnection.this.channel().localAddress().toString(), (Object)UdpForwardBackendConnection.this.destAddress.toString());
                UdpForwardBackendConnection.this.channel().writeAndFlush((Object)new DatagramPacket(Unpooled.wrappedBuffer((byte[])packet.getData()), UdpForwardBackendConnection.this.destAddress));
            }
        };
    }
}

