/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine.impl.frontend;

import com.xdja.csagent.engine.Agent;
import com.xdja.csagent.engine.AgentConnection;
import com.xdja.csagent.engine.IConnPacketListener;
import com.xdja.csagent.engine.RouteSender;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.engine.packet.ConnectBegin;
import com.xdja.csagent.engine.packet.DataPacket;
import com.xdja.csagent.engine.packet.FeedbackPacket;
import com.xdja.csagent.engine.plugins.IConnectionPlugin;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.handler.codec.socks.SocksAuthScheme;
import io.netty.handler.codec.socks.SocksCmdRequest;
import io.netty.handler.codec.socks.SocksCmdRequestDecoder;
import io.netty.handler.codec.socks.SocksCmdResponse;
import io.netty.handler.codec.socks.SocksCmdStatus;
import io.netty.handler.codec.socks.SocksCmdType;
import io.netty.handler.codec.socks.SocksInitRequestDecoder;
import io.netty.handler.codec.socks.SocksInitResponse;
import io.netty.handler.codec.socks.SocksMessageEncoder;
import io.netty.handler.codec.socks.SocksRequest;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocksFrontendConnection
extends AgentConnection {
    private static final SocksMessageEncoder socksMessageEncoder = new SocksMessageEncoder();
    public final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Agent agent;
    private SocksCmdRequest connectionCmdRequest;

    public SocksFrontendConnection(String id, Channel channel, RouteSender routeSender, Agent agent) {
        super(id, channel, routeSender);
        this.agent = agent;
        this.init(channel);
    }

    @Override
    public void close() {
        this.channel().close().syncUninterruptibly();
    }

    private boolean activeIntercept(ChannelHandlerContext ctx) {
        try {
            for (IConnectionPlugin plugin : this.getConnectionPlugins()) {
                if (!plugin.activeIntercept(ctx.channel(), this.agent.getAgentMeta(), null)) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Connection Plugin Execute Error!", (Throwable)e);
        }
        return false;
    }

    private void addDataFlowHandler(Channel channel) {
        channel.pipeline().addBefore("lifecyle", "dataFlowHandler", (ChannelHandler)new SimpleChannelInboundHandler<byte[]>(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                SocksFrontendConnection.this.channel().read();
                super.channelActive(ctx);
            }

            protected void channelRead0(ChannelHandlerContext ctx, byte[] msg) throws Exception {
                DataPacket dataPacket = new DataPacket(SocksFrontendConnection.this.id());
                dataPacket.setData(msg);
                SocksFrontendConnection.this.routeSender.sendToRoute(dataPacket);
            }
        });
    }

    @Override
    public void applyNewConfig() {
        try {
            for (IConnectionPlugin plugin : this.getConnectionPlugins()) {
                plugin.applyNewConfig(this.channel(), this.agent.getAgentMeta());
            }
        }
        catch (Exception e) {
            this.logger.error("Connection Plugin Execute Error!", (Throwable)e);
        }
    }

    public void doWork(SocksCmdRequest request) {
        ConnectBegin connectBegin = new ConnectBegin(this.id(), 4);
        connectBegin.setHost(request.host());
        connectBegin.setPort(request.port());
        this.routeSender.sendToRoute(connectBegin);
    }

    private void init(Channel channel) {
        channel.pipeline().addLast("initDecoder", (ChannelHandler)new SocksInitRequestDecoder());
        channel.pipeline().addLast("socksEncoder", (ChannelHandler)socksMessageEncoder);
        channel.pipeline().addLast("logicHandler", (ChannelHandler)new SimpleChannelInboundHandler<SocksRequest>(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                super.channelActive(ctx);
                ctx.read();
            }

            public void channelRead0(ChannelHandlerContext ctx, SocksRequest socksRequest) throws Exception {
                switch (socksRequest.requestType()) {
                    case INIT: {
                        ctx.pipeline().addBefore("socksEncoder", "cmdDecoder", (ChannelHandler)new SocksCmdRequestDecoder());
                        ctx.write((Object)new SocksInitResponse(SocksAuthScheme.NO_AUTH));
                        ctx.read();
                        break;
                    }
                    case CMD: {
                        SocksCmdRequest req = (SocksCmdRequest)socksRequest;
                        if (req.cmdType() == SocksCmdType.CONNECT) {
                            SocksFrontendConnection.this.connectionCmdRequest = req;
                            SocksFrontendConnection.this.doWork(req);
                            ctx.pipeline().remove("logicHandler");
                            ctx.read();
                            break;
                        }
                        ctx.close();
                        break;
                    }
                    case UNKNOWN: {
                        ctx.close();
                    }
                }
            }

            public void channelReadComplete(ChannelHandlerContext ctx) {
                ctx.flush();
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                SocksFrontendConnection.this.logger.warn("\u8fde\u63a5\u672a\u77e5\u5f02\u5e38", cause);
                ctx.close();
            }
        });
        channel.pipeline().addLast("lifecyle", (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                if (!SocksFrontendConnection.this.activeIntercept(ctx)) {
                    super.channelActive(ctx);
                }
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                super.channelInactive(ctx);
                if (SocksFrontendConnection.this.partnerClosed) {
                    SocksFrontendConnection.this.logger.debug("\u5bf9\u7aef\u5df2\u5173\u95ed\uff0c\u65e0\u9700\u901a\u77e5");
                } else {
                    SocksFrontendConnection.this.logger.debug("notify: connection close");
                    SocksFrontendConnection.this.routeSender.sendToRoute(new FeedbackPacket(SocksFrontendConnection.this.id(), 1));
                }
                SocksFrontendConnection.this.logger.debug("INACTIVE " + ctx.channel().toString());
            }
        });
    }

    @Override
    protected IConnPacketListener newConnPacketListener() {
        return new IConnPacketListener(){

            @Override
            public void onPartnerConnectClose(AgentConnection agentConnection, FeedbackPacket feedback) {
                SocksFrontendConnection.this.partnerClosed = true;
                SocksFrontendConnection.this.channel().close();
            }

            @Override
            public void onPartnerConnectFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
                SocksFrontendConnection.this.partnerClosed = true;
                SocksFrontendConnection.this.channel().writeAndFlush((Object)new SocksCmdResponse(SocksCmdStatus.FAILURE, SocksFrontendConnection.this.connectionCmdRequest.addressType()));
                Utils.closeOnFlush(SocksFrontendConnection.this.channel());
            }

            @Override
            public void onPartnerConnectSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
                SocksFrontendConnection.this.channel().writeAndFlush((Object)new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksFrontendConnection.this.connectionCmdRequest.addressType())).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) {
                        SocksFrontendConnection.this.channel().pipeline().addBefore("lifecyle", "byteArrayDecoder", (ChannelHandler)new ByteArrayDecoder());
                        SocksFrontendConnection.this.channel().pipeline().addBefore("lifecyle", "byteArrayEncoder", (ChannelHandler)new ByteArrayEncoder());
                        SocksFrontendConnection.this.addDataFlowHandler(SocksFrontendConnection.this.channel());
                    }
                });
            }

            @Override
            public void onPartnerWriteFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
                SocksFrontendConnection.this.channel().close();
            }

            @Override
            public void onPartnerWriteSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
                SocksFrontendConnection.this.logger.debug("read data from channel");
                SocksFrontendConnection.this.channel().read();
            }

            @Override
            public void receivePartnerData(AgentConnection agentConnection, DataPacket data) {
                SocksFrontendConnection.this.channel().writeAndFlush((Object)data.getData()).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            SocksFrontendConnection.this.logger.debug("notify: write data success");
                            SocksFrontendConnection.this.routeSender.sendToRoute(new FeedbackPacket(SocksFrontendConnection.this.id(), 5));
                            SocksFrontendConnection.this.logger.debug("read data from channel again");
                            SocksFrontendConnection.this.channel().read();
                        } else {
                            SocksFrontendConnection.this.logger.debug("notify: write data failure");
                            SocksFrontendConnection.this.routeSender.sendToRoute(new FeedbackPacket(SocksFrontendConnection.this.id(), 4));
                        }
                    }
                });
            }
        };
    }
}

