/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine.impl.frontend;

import com.xdja.csagent.engine.Agent;
import com.xdja.csagent.engine.AgentConnection;
import com.xdja.csagent.engine.IConnPacketListener;
import com.xdja.csagent.engine.RouteSender;
import com.xdja.csagent.engine.impl.custom.UdpConnectionCloseEvent;
import com.xdja.csagent.engine.packet.DataPacket;
import com.xdja.csagent.engine.packet.FeedbackPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;

public class UdpForwardFrontendConnection
extends AgentConnection {
    private final Agent agent;
    private final InetSocketAddress sourceAddress;

    public UdpForwardFrontendConnection(String id, Channel channel, RouteSender routeSender, Agent agent, InetSocketAddress sender) {
        super(id, channel, routeSender);
        this.agent = agent;
        this.sourceAddress = sender;
    }

    @Override
    public void applyNewConfig() {
    }

    @Override
    public void close() {
        this.channel().pipeline().fireUserEventTriggered((Object)new UdpConnectionCloseEvent(this.id()));
        this.routeSender.sendToRoute(new FeedbackPacket(this.id(), 1));
    }

    @Override
    protected IConnPacketListener newConnPacketListener() {
        return new IConnPacketListener(){

            @Override
            public void onPartnerConnectClose(AgentConnection agentConnection, FeedbackPacket feedback) {
            }

            @Override
            public void onPartnerConnectFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
            }

            @Override
            public void onPartnerConnectSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
            }

            @Override
            public void onPartnerWriteFailure(AgentConnection agentConnection, FeedbackPacket feedback) {
            }

            @Override
            public void onPartnerWriteSuccess(AgentConnection agentConnection, FeedbackPacket feedback) {
            }

            @Override
            public void receivePartnerData(AgentConnection agentConnection, DataPacket packet) {
                UdpForwardFrontendConnection.this.channel().writeAndFlush((Object)new DatagramPacket(Unpooled.wrappedBuffer((byte[])packet.getData()), UdpForwardFrontendConnection.this.sourceAddress));
            }
        };
    }

    public void onReceiveDatagramPacket(DatagramPacket msg) {
        DataPacket one = new DataPacket(this.id(), true);
        int len = ((ByteBuf)msg.content()).readableBytes();
        byte[] bs = new byte[len];
        ((ByteBuf)msg.content()).readBytes(bs);
        one.setData(bs);
        this.routeSender.sendToRoute(one);
    }
}

