/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.CharsetUtil;

public class EncoderUtils {
    private static final char SLASH = '/';
    private static final byte[] CRLF = new byte[]{13, 10};

    public static byte[] encodeHttpRequest(HttpRequest request) {
        ByteBuf buf = Unpooled.buffer();
        EncoderUtils.encodeRequestInitialLine(buf, request);
        HttpHeaders.encode((HttpHeaders)request.headers(), (ByteBuf)buf);
        buf.writeBytes(CRLF);
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        buf.release();
        return bytes;
    }

    private static void encodeRequestInitialLine(ByteBuf buf, HttpRequest request) {
        request.getMethod().encode(buf);
        buf.writeByte(32);
        String uri = request.getUri();
        if (uri.length() == 0) {
            uri = uri + '/';
        } else {
            int start = uri.indexOf("://");
            if (start != -1 && uri.charAt(0) != '/') {
                int startIndex = start + 3;
                if (uri.lastIndexOf(47) <= startIndex) {
                    uri = uri + '/';
                }
            }
        }
        buf.writeBytes(uri.getBytes(CharsetUtil.UTF_8));
        buf.writeByte(32);
        request.getProtocolVersion().encode(buf);
        buf.writeBytes(CRLF);
    }

    public static byte[] encodehttpResponse(HttpResponse response) {
        ByteBuf buf = Unpooled.buffer();
        EncoderUtils.encodeResponseInitialLine(buf, response);
        HttpHeaders.encode((HttpHeaders)response.headers(), (ByteBuf)buf);
        buf.writeBytes(CRLF);
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        buf.release();
        return bytes;
    }

    private static void encodeResponseInitialLine(ByteBuf buf, HttpResponse response) {
        response.getProtocolVersion().encode(buf);
        buf.writeByte(32);
        response.getStatus().encode(buf);
        buf.writeBytes(CRLF);
    }
}

