/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.common.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    public static final ObjectMapper mapper = JsonUtils.getObjectMapper();

    private static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    public static String toJsonStr(Object value) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u5bf9\u8c61\u4e3aJSON\u5b57\u7b26\u4e32\u5f02\u5e38", (Throwable)e);
            return "";
        }
    }

    public static Map<String, Object> toMap(String json) {
        try {
            return (Map)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructMapType(HashMap.class, String.class, Object.class));
        }
        catch (IOException e) {
            log.error("\u89e3\u6790json\u51fa\u9519!", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static <T> T readValue(String context, Class<T> valueType) {
        try {
            return (T)mapper.readValue(context, valueType);
        }
        catch (Exception e) {
            log.error("\u8f6c\u5316json\u5b57\u7b26\u4e32\u4e3a\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static <T> T readValue(String context, Class<? extends Collection> collectionClass, Class<?> elementCLasses) {
        try {
            return (T)mapper.readValue(context, (JavaType)mapper.getTypeFactory().constructCollectionType(collectionClass, elementCLasses));
        }
        catch (Exception e) {
            log.error("\u8f6c\u5316json\u5b57\u7b26\u4e32\u4e3a\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }
}

