/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.common.util;

import com.xdja.common.util.Tuple;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class NetworkTester {
    private static Logger logger = LoggerFactory.getLogger(NetworkTester.class);

    public static boolean connectDirectTest(String host, int port, int timeoutSecond) {
        return NetworkTester.connectTest((String)host, (int)port, (int)timeoutSecond, null);
    }

    public static boolean connectProxyTest(String host, int port, int timeoutSecond, String socksHost, int socksPort) {
        InetSocketAddress proxy = new InetSocketAddress(socksHost, socksPort);
        Proxy socksProxy = new Proxy(Proxy.Type.SOCKS, proxy);
        return NetworkTester.connectTest((String)host, (int)port, (int)timeoutSecond, (Proxy)socksProxy);
    }

    public static boolean connectTest(String host, int port, int timeout, Proxy socksProxy) {
        boolean status = false;
        try {
            Socket socket = null;
            socket = socksProxy != null ? new Socket(socksProxy) : new Socket();
            socket.connect(new InetSocketAddress(host, port), timeout);
            logger.info("IP:{} Port:{}\u6b63\u5e38\u8fde\u63a5", (Object)host, (Object)port);
            status = socket.isConnected();
            socket.close();
        }
        catch (Exception e) {
            logger.error("IP:{} Port:{}\u8fde\u63a5\u5931\u8d25", (Object)host, (Object)port);
        }
        return status;
    }

    public static boolean connectTest(String host) {
        boolean status = false;
        int timeout = 2000;
        try {
            if (InetAddress.getByName(host).isReachable(timeout)) {
                logger.debug("IP:{}\u6b63\u5e38\u8fde\u63a5", (Object)host);
                status = true;
            } else {
                logger.debug("IP:{}\u65e0\u6cd5\u8fde\u63a5", (Object)host);
                status = false;
            }
        }
        catch (Exception e) {
            logger.error("IP:{}\u8fde\u63a5\u5931\u8d25", (Object)host);
        }
        return status;
    }

    public static boolean ipCheck(String ip) {
        Pattern pattern = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)$");
        Matcher matcher = pattern.matcher(ip);
        boolean b = matcher.matches();
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocalPortAvailable(int port) {
        ServerSocket serverSocket = null;
        boolean rst = false;
        try {
            serverSocket = new ServerSocket(port);
            rst = true;
        }
        catch (Exception e) {
            logger.info("\u7aef\u53e3{}\u6d4b\u8bd5\u5931\u8d25:" + e.getMessage(), (Object)port);
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (Exception exception) {}
            }
        }
        return rst;
    }

    public static Tuple<Boolean, String> isOracleJdbcAvailable(String url, String driver, String username, String password) {
        try {
            SimpleDriverDataSource ds = new SimpleDriverDataSource();
            ds.setDriverClass(Class.forName(driver));
            ds.setUrl(url);
            ds.setUsername(username);
            ds.setPassword(password);
            new JdbcTemplate((DataSource)ds).execute("select 1 from dual");
            return new Tuple((Object)true, (Object)"success");
        }
        catch (Exception e) {
            return new Tuple((Object)false, (Object)e.getMessage());
        }
    }
}

