/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.common.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SpringInsertBuilder {
    private final String sqlInsert;
    private List<String> fields = new ArrayList();
    private List<Map.Entry<Boolean, Object>> arguments = new ArrayList();

    private SpringInsertBuilder(String insertSql) {
        this.sqlInsert = insertSql;
    }

    public static SpringInsertBuilder create(String insertSql) {
        return new SpringInsertBuilder(insertSql);
    }

    public SpringInsertBuilder hold(String field, Object param) {
        this.fields.add(field);
        this.arguments.add(new AbstractMap.SimpleEntry<Boolean, Object>(false, param));
        return this;
    }

    public SpringInsertBuilder direct(String field, String param) {
        this.fields.add(field);
        this.arguments.add(new AbstractMap.SimpleEntry<Boolean, String>(true, param));
        return this;
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder(this.sqlInsert);
        sb.append(" (");
        for (String f : this.fields) {
            sb.append(f);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(") values (");
        for (Map.Entry one : this.arguments) {
            if (((Boolean)one.getKey()).booleanValue()) {
                sb.append(one.getValue() + ",");
                continue;
            }
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        return sb.toString();
    }

    public Object[] toArguments() {
        ArrayList rst = new ArrayList();
        for (Map.Entry one : this.arguments) {
            if (((Boolean)one.getKey()).booleanValue()) continue;
            rst.add(one.getValue());
        }
        return rst.toArray();
    }
}

