/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.base.dao.impl;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xdja.common.util.JsonUtils;
import com.xdja.common.util.SpringInsertBuilder;
import com.xdja.common.util.SpringSqlBuilder;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.webui.base.bean.AgentInfoBean;
import com.xdja.csagent.webui.base.bean.OperateLogBean;
import com.xdja.csagent.webui.base.bean.UserBean;
import com.xdja.csagent.webui.base.bean.UserToMenuBean;
import com.xdja.csagent.webui.base.dao.ICSDao;
import com.xdja.csagent.webui.base.entity.AgentParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class CSDaoImpl
implements ICSDao {
    @Autowired
    public JdbcTemplate jdbcTemplate;
    @Autowired
    public NamedParameterJdbcTemplate namedJdbcTemplate;
    private RowMapper<UserBean> userBeanRowMapper = new /* Unavailable Anonymous Inner Class!! */;
    private RowMapper<UserToMenuBean> userToMenuBeanRowMapper = new /* Unavailable Anonymous Inner Class!! */;

    public int countAgentParamList(AgentInfoBean portBean) {
        throw new UnsupportedOperationException();
    }

    public int countOperateLog(OperateLogBean queryParam) {
        if (queryParam == null) {
            queryParam = new OperateLogBean();
        }
        SpringSqlBuilder builder = SpringSqlBuilder.create((String)"SELECT count(0) ", (Object[])new Object[0]).append("FROM t_logs_user g WHERE 1=1 ", new Object[0]);
        if (StringUtils.hasText((String)queryParam.getUserName())) {
            builder.append(" AND g.c_user_name like ? ", new Object[]{"%" + queryParam.getUserName() + "%"});
        }
        if (queryParam.getResult() != null) {
            builder.append(" AND g.n_result = ? ", new Object[]{queryParam.getResult()});
        }
        if (StringUtils.hasText((String)queryParam.getArgs())) {
            builder.append(" AND g.t_args like ? ", new Object[]{"%" + queryParam.getArgs() + "%"});
        }
        if (StringUtils.hasText((String)queryParam.getNote())) {
            builder.append(" AND g.t_note like ? ", new Object[]{"%" + queryParam.getNote() + "%"});
        }
        if (queryParam.getSearchStartTime() != null) {
            builder.append(" AND g.d_createtime >= ?", new Object[]{queryParam.getSearchStartTime()});
        }
        if (queryParam.getSearchEndTime() != null) {
            builder.append(" AND g.d_createtime < ?", new Object[]{DateUtils.addDays((Date)queryParam.getSearchEndTime(), (int)1)});
        }
        if (StringUtils.hasText((String)queryParam.getLogsType())) {
            builder.append(" AND concat(g.c_class,'.',g.c_method)= ?", new Object[]{queryParam.getLogsType()});
        }
        return ((Number)this.jdbcTemplate.queryForObject(builder.toSql(), builder.toArguments(), Number.class)).intValue();
    }

    public int countUser(UserBean user) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT count(0) FROM t_user t WHERE 1=1 ");
        ArrayList<String> argList = new ArrayList<String>();
        if (user != null && user.getName() != null && !"".equals(user.getName())) {
            sql.append(" AND t.c_name like ? ");
            argList.add("%" + user.getName() + "%");
        }
        Object[] args = argList.toArray();
        return (Integer)this.jdbcTemplate.queryForObject(sql.toString(), args, Integer.class);
    }

    public int countUserByName(String userName) {
        return (Integer)this.jdbcTemplate.queryForObject("select count(1) from t_user where c_name=?", Integer.class, new Object[]{userName});
    }

    public void deleteAgentParam(String uuid) {
        this.jdbcTemplate.update("DELETE FROM t_agent_param WHERE n_id = ?", new Object[]{uuid});
    }

    public void deleteAllOperateLog() {
        this.jdbcTemplate.update("delete from t_logs_user");
    }

    public void deleteOperateLogBetweenTime(Date start, Date end) {
        end = DateUtils.addDays((Date)end, (int)1);
        String sql = "DELETE FROM t_logs_user where d_createtime >= ? and d_createtime < ?";
        this.jdbcTemplate.update(sql, new Object[]{start, end});
    }

    public void deleteUser(String uuid) {
        this.jdbcTemplate.update("delete from t_user where n_id=?", new Object[]{uuid});
    }

    public void deleteUserToMenuByUser(String userId) {
        this.jdbcTemplate.update("delete from t_user_menu where n_user_id=?", new Object[]{userId});
    }

    public AgentParam findAgentParam(String uuid) {
        List jsons = this.jdbcTemplate.queryForList("select t_json from t_agent_param where n_id=?", String.class, new Object[]{uuid});
        String json = (String)Iterables.getFirst((Iterable)jsons, null);
        if (StringUtils.hasText((String)json)) {
            return this.json2AgentParam(json);
        }
        return null;
    }

    public List<AgentParam> findAgentParamByPort(Integer port) {
        List jsons = this.jdbcTemplate.queryForList("select t_json from t_agent_param", String.class);
        ArrayList rst = Lists.newArrayList();
        for (String json : jsons) {
            AgentParam tmp = this.json2AgentParam(json);
            if (tmp == null || !tmp.getAgentPort().equals(port)) continue;
            rst.add(tmp);
        }
        this.sortAgentParamList((List)rst);
        return rst;
    }

    public List<AgentParam> findAgentParamList(AgentInfoBean portBean, Integer pagesize, Integer pageNo) {
        List jsons = this.jdbcTemplate.queryForList("select t_json from t_agent_param", String.class);
        ArrayList rst = Lists.newArrayList();
        for (String json : jsons) {
            AgentParam tmp = this.json2AgentParam(json);
            if (tmp == null || portBean.getAgentPort() != null && portBean.getAgentPort() != 0 && !tmp.getAgentPort().equals(portBean.getAgentPort()) || portBean.getAgentType() != null && portBean.getAgentType() != 0 && !tmp.getAgentType().equals(portBean.getAgentType()) || portBean.getNote() != null && !"".equals(portBean.getNote()) && !tmp.getNote().contains(portBean.getNote())) continue;
            rst.add(tmp);
        }
        this.sortAgentParamList((List)rst);
        return rst;
    }

    private void sortAgentParamList(List<AgentParam> rst) {
        Collections.sort(rst, new /* Unavailable Anonymous Inner Class!! */);
    }

    private AgentParam json2AgentParam(String json) {
        AgentParam agentParam = (AgentParam)JsonUtils.readValue((String)json, AgentParam.class);
        return agentParam;
    }

    public List<AgentParam> findAgentParamList() {
        List jsons = this.jdbcTemplate.queryForList("select t_json from t_agent_param", String.class);
        ArrayList rst = Lists.newArrayList();
        for (String json : jsons) {
            AgentParam tmp = this.json2AgentParam(json);
            if (tmp == null) continue;
            rst.add(tmp);
        }
        this.sortAgentParamList((List)rst);
        return rst;
    }

    public List<OperateLogBean> findOperateLog(OperateLogBean queryParam, Integer pageSize, Integer pageNo) {
        if (queryParam == null) {
            queryParam = new OperateLogBean();
        }
        SpringSqlBuilder builder = SpringSqlBuilder.create((String)"SELECT g.n_id as id,g.c_user_name as userName,concat(g.c_class,'.',g.c_method) as logsType,g.c_class as className,g.c_method as methodName,g.t_args as args,g.n_result as result,g.t_note as note,g.d_createtime as createtime,g.n_use_time as userTime,g.c_uuid as uuid ", (Object[])new Object[0]).append("FROM t_logs_user g WHERE 1=1 ", new Object[0]);
        if (StringUtils.hasText((String)queryParam.getUserName())) {
            builder.append(" AND g.c_user_name like ? ", new Object[]{"%" + queryParam.getUserName() + "%"});
        }
        if (queryParam.getResult() != null) {
            builder.append(" AND g.n_result = ? ", new Object[]{queryParam.getResult()});
        }
        if (StringUtils.hasText((String)queryParam.getArgs())) {
            builder.append(" AND g.t_args like :args ", new Object[]{"%" + queryParam.getArgs() + "%"});
        }
        if (StringUtils.hasText((String)queryParam.getNote())) {
            builder.append(" AND g.t_note like ? ", new Object[]{"%" + queryParam.getNote() + "%"});
        }
        if (queryParam.getSearchStartTime() != null) {
            builder.append(" AND g.d_createtime >= ?", new Object[]{queryParam.getSearchStartTime()});
        }
        if (queryParam.getSearchEndTime() != null) {
            builder.append(" AND g.d_createtime < ?", new Object[]{DateUtils.addDays((Date)queryParam.getSearchEndTime(), (int)1)});
        }
        if (StringUtils.hasText((String)queryParam.getLogsType())) {
            builder.append(" AND logsClassAndMethod= ?", new Object[]{queryParam.getLogsType()});
        }
        builder.append(" ORDER BY g.d_createtime desc  ", new Object[0]);
        if (pageNo != null && pageSize != null) {
            int start = (pageNo - 1) * pageSize;
            builder.append(" limit ?,?", new Object[]{start, pageSize});
        }
        List list = this.jdbcTemplate.query(builder.toSql(), builder.toArguments(), (RowMapper)ParameterizedBeanPropertyRowMapper.newInstance(OperateLogBean.class));
        return list;
    }

    public UserBean findUser(String uuid) {
        List query = this.jdbcTemplate.query("select * from t_user where n_id=?", this.userBeanRowMapper, new Object[]{uuid});
        return (UserBean)Iterables.getFirst((Iterable)query, null);
    }

    public UserBean findUserByName(String name) {
        List query = this.jdbcTemplate.query("select * from t_user where c_name=?", this.userBeanRowMapper, new Object[]{name});
        return (UserBean)Iterables.getFirst((Iterable)query, null);
    }

    public List<UserBean> findUserList() {
        return this.jdbcTemplate.query("select * from t_user", this.userBeanRowMapper);
    }

    public List<UserBean> findUserList(UserBean user, Integer pageSize, Integer pageNo) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT *  FROM t_user t WHERE 1=1 ");
        ArrayList<Object> argList = new ArrayList<Object>();
        if (user != null && StringUtils.hasText((String)user.getName())) {
            sql.append(" AND t.c_name like ? ");
            argList.add("%" + user.getName() + "%");
        }
        sql.append(" limit ?,? ");
        argList.add((pageNo - 1) * pageSize);
        argList.add(pageSize);
        Object[] args = argList.toArray();
        List query = this.jdbcTemplate.query(sql.toString(), args, this.userBeanRowMapper);
        Collections.sort(query, new /* Unavailable Anonymous Inner Class!! */);
        return query;
    }

    public List<UserToMenuBean> findUserToMenuByUser(String userId) {
        return this.jdbcTemplate.query("select * from t_user_menu where n_user_id=?", this.userToMenuBeanRowMapper, new Object[]{userId});
    }

    public void saveAgentParam(AgentParam portBean) {
        if (!StringUtils.hasText((String)portBean.getId())) {
            portBean.setId(Utils.uuid());
        }
        SpringInsertBuilder builder = SpringInsertBuilder.create((String)"insert into t_agent_param").hold("n_id", (Object)portBean.getId()).hold("t_json", (Object)JsonUtils.toJsonStr((Object)portBean));
        this.jdbcTemplate.update(builder.toSql(), builder.toArguments());
    }

    public void saveOperateLog(List<OperateLogBean> logs) {
        String sql = "insert into t_logs_user (n_id,c_user_name,c_class,c_method,t_args,n_result,t_note,d_createtime,n_use_time,c_uuid)values(:id,:userName,:className,:methodName,:args,:result,:note,:createtime,:useTime,:uuid)";
        Collection sources = Collections2.transform(logs, (Function)new /* Unavailable Anonymous Inner Class!! */);
        this.namedJdbcTemplate.batchUpdate(sql, sources.toArray(new SqlParameterSource[0]));
    }

    public void saveUserToMenu(UserToMenuBean obj) {
        SpringInsertBuilder builder = SpringInsertBuilder.create((String)"insert into t_user_menu ").hold("n_id", (Object)obj.getId()).hold("n_user_id", (Object)obj.getUserId()).hold("n_menu_id", (Object)obj.getMenuId());
        this.jdbcTemplate.update(builder.toSql(), builder.toArguments());
    }

    public void saveUserToMenu(List<UserToMenuBean> objs) {
        String sql = "insert into t_user_menu (n_id,n_user_id,n_menu_id) values (:id,:userId,:menuId)";
        Collection sources = Collections2.transform(objs, (Function)new /* Unavailable Anonymous Inner Class!! */);
        this.namedJdbcTemplate.batchUpdate(sql, sources.toArray(new SqlParameterSource[0]));
    }

    public void saveUser(UserBean user) {
        SpringInsertBuilder builder = SpringInsertBuilder.create((String)"insert into t_user ").hold("n_id", (Object)user.getId()).hold("c_name", (Object)user.getName()).hold("c_password", (Object)user.getPassword()).hold("n_status", (Object)user.getStatus()).hold("c_note", (Object)user.getNote());
        this.jdbcTemplate.update(builder.toSql(), builder.toArguments());
    }

    public void updateAgentParam(AgentParam portBean) {
        SpringSqlBuilder builder = SpringSqlBuilder.create((String)"update t_agent_param ", (Object[])new Object[0]).append("set t_json=?", new Object[]{JsonUtils.toJsonStr((Object)portBean)}).append(" WHERE n_id=?", new Object[]{portBean.getId()});
        this.jdbcTemplate.update(builder.toSql(), builder.toArguments());
    }

    public void updateUser(UserBean user) {
        SpringSqlBuilder builder = SpringSqlBuilder.create((String)"update t_user set ", (Object[])new Object[0]).append("c_name=?", new Object[]{user.getName()}).append(",c_password=?", new Object[]{user.getPassword()}).append(",n_status=?", new Object[]{user.getStatus()}).append(",c_note=?", new Object[]{user.getNote()}).append(" where n_id=?", new Object[]{user.getId()});
        this.jdbcTemplate.update(builder.toSql(), builder.toArguments());
    }
}

