/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.base.listener;

import com.google.common.io.Files;
import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SystemPropertyInitListener
implements ServletContextListener {
    public static final String CS_HOME = "csHome";
    public static final String TOMCAT_BASE = "catalina.base";
    public static final String INIT_ERROR = "InitError";

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            File logsDir;
            String csHome = null;
            if (StringUtils.hasText((String)System.getProperty(CS_HOME))) {
                csHome = System.getProperty(CS_HOME).trim();
            } else {
                String catalinaBase = System.getProperty(TOMCAT_BASE);
                Assert.hasText((String)catalinaBase, (String)"\u83b7\u53d6\u5c5e\u6027catalina.base\u5931\u8d25");
                csHome = new File(catalinaBase, CS_HOME).getAbsolutePath();
            }
            File csHomeDir = new File(csHome);
            if (!csHomeDir.exists()) {
                Assert.isTrue((boolean)csHomeDir.mkdirs(), (String)("\u521b\u5efa\u76ee\u5f55" + csHome + "\u5931\u8d25"));
            }
            Iterable subFilesTraverser = Files.fileTreeTraverser().children((Object)csHomeDir);
            for (File one : subFilesTraverser) {
                Assert.isTrue((boolean)one.canRead(), (String)(one.getAbsolutePath() + "\u6ca1\u6709\u8bfb\u6743\u9650"));
                Assert.isTrue((boolean)one.canWrite(), (String)(one.getAbsolutePath() + "\u6ca1\u6709\u5199\u6743\u9650"));
                if (!one.isDirectory()) continue;
                Assert.isTrue((boolean)one.canExecute(), (String)(one.getAbsolutePath() + "\u6ca1\u6709\u6267\u884c\u6743\u9650"));
            }
            File confDir = new File(csHomeDir, "conf");
            if (!confDir.exists()) {
                confDir.mkdir();
            }
            if (!(logsDir = new File(csHomeDir, "logs")).exists()) {
                logsDir.mkdir();
            }
            System.setProperty(CS_HOME, csHomeDir.getAbsolutePath());
        }
        catch (Exception e) {
            ServletContext application = servletContextEvent.getServletContext();
            application.setAttribute(INIT_ERROR, (Object)("\u65e0\u6cd5\u786e\u5b9acsHome:" + e.getMessage()));
            System.setProperty(CS_HOME, Files.createTempDir().getAbsolutePath());
            e.printStackTrace();
        }
    }

    public static String getCsHome() {
        return System.getProperty(CS_HOME);
    }
}

