/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.base.manager;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xdja.common.util.Collections3;
import com.xdja.common.util.ICallback;
import com.xdja.common.util.Tuple;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.webui.base.bean.Menu;
import com.xdja.csagent.webui.base.bean.MenuUrl;
import com.xdja.csagent.webui.base.bean.Navigate;
import com.xdja.csagent.webui.base.bean.Node;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;

public class MenuListService
implements InitializingBean {
    private Logger logger = LoggerFactory.getLogger(MenuListService.class);
    private ObjectMapper json = new ObjectMapper();
    private List<Navigate> navigates;
    private Map<String, Node> nodeMap;
    private boolean debug;

    public void afterPropertiesSet() throws Exception {
        ClassPathResource classPathResource = new ClassPathResource("/menulist.json");
        if (!classPathResource.exists()) {
            throw new FileNotFoundException(classPathResource.getPath());
        }
        JsonNode root = this.json.readTree(classPathResource.getFile());
        String navs = root.get("navs").toString();
        this.logger.debug("menulist.json :\r\n{}", (Object)navs);
        this.navigates = (List)this.json.readValue(navs, (JavaType)this.json.getTypeFactory().constructCollectionType(List.class, Navigate.class));
        this.nodeMap = this.buildMap(this.navigates);
    }

    private Map<String, Node> buildMap(List<Navigate> navigates) {
        HashMap<String, Node> rst = new HashMap<String, Node>();
        Collections3.each(navigates, (ICallback)new /* Unavailable Anonymous Inner Class!! */);
        return rst;
    }

    public Tuple<List<Navigate>, List<Menu>> findByHref(String href) {
        Navigate tmp;
        this.prepare();
        href = Utils.fixContextPath((String)href);
        ArrayList<Navigate> rstA = new ArrayList<Navigate>();
        ArrayList<Navigate> rstB = new ArrayList<Navigate>();
        Tuple target = this.findNavigateByHref(href);
        if (target == null) {
            return new Tuple(Collections.emptyList(), Collections.emptyList());
        }
        for (Navigate nav : this.navigates) {
            tmp = new Navigate();
            BeanUtils.copyProperties((Object)nav, (Object)tmp, (String[])new String[]{"menus"});
            if (nav.equals(target.getA())) {
                tmp.setActive(true);
            }
            rstA.add(tmp);
        }
        for (Menu menu : ((Navigate)target.getA()).getMenus()) {
            tmp = new Menu();
            BeanUtils.copyProperties((Object)menu, (Object)tmp, (String[])new String[]{"urls"});
            if (menu.equals(target.getB())) {
                tmp.setActive(true);
            }
            rstB.add(tmp);
        }
        return new Tuple(rstA, rstB);
    }

    public String findHrefByMenuId(String menuId) {
        Node node = (Node)this.nodeMap.get(menuId);
        if (node != null) {
            return node.getHref();
        }
        return null;
    }

    private Tuple<Navigate, Menu> findNavigateByHref(String href) {
        for (Navigate nav : this.navigates) {
            for (Menu menu : nav.getMenus()) {
                for (MenuUrl url : menu.getUrls()) {
                    if (!url.getHref().equalsIgnoreCase(href)) continue;
                    return new Tuple((Object)nav, (Object)menu);
                }
            }
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            MenuListService a = new MenuListService();
            a.afterPropertiesSet();
            Tuple byHref = a.findByHref("/port/ieRegister.do");
            System.out.println(byHref);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Node> findNodesByHref(String requestUrl) {
        ArrayList<Node> rst = new ArrayList<Node>();
        for (Node node : this.nodeMap.values()) {
            if (!node.getHref().equalsIgnoreCase(requestUrl)) continue;
            rst.add(node);
        }
        return rst;
    }

    public List<Node> findAllMenuList() {
        return Lists.newArrayList(this.nodeMap.values());
    }

    public boolean getDebug() {
        return this.debug;
    }

    public String getDefaultMenuHref() {
        this.prepare();
        Navigate firstNav = (Navigate)Iterables.getFirst((Iterable)this.navigates, null);
        if (firstNav != null) {
            return firstNav.getHref();
        }
        throw new IllegalStateException("No MenuList in System!!!");
    }

    public boolean hasHref(String requestUrl) {
        for (Node node : this.nodeMap.values()) {
            if (!node.getHref().equalsIgnoreCase(requestUrl)) continue;
            return true;
        }
        return false;
    }

    public int menuListCount() {
        return this.nodeMap.size();
    }

    private void prepare() {
        if (this.debug) {
            try {
                this.afterPropertiesSet();
            }
            catch (Exception e) {
                this.logger.error("reload menulist.json error!!!", (Throwable)e);
            }
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

