/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.base.manager.impl;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.xdja.common.util.Collections3;
import com.xdja.common.util.ICallback;
import com.xdja.common.util.page.Pagination;
import com.xdja.csagent.engine.AgentMeta;
import com.xdja.csagent.engine.CSEngine;
import com.xdja.csagent.engine.MakerUtils;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.engine.bean.DataSwapStatus;
import com.xdja.csagent.webui.base.bean.AgentInfoBean;
import com.xdja.csagent.webui.base.bean.DefaultAgentMeta;
import com.xdja.csagent.webui.base.bean.IpFilterBean;
import com.xdja.csagent.webui.base.dao.ICSDao;
import com.xdja.csagent.webui.base.entity.AgentParam;
import com.xdja.csagent.webui.base.manager.AgentManager;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class AgentManagerImpl
implements AgentManager {
    @Resource
    private CSEngine engine;
    @Resource
    private ICSDao dao;
    private Long agentConfigLastUpdateTime = System.currentTimeMillis();

    public void addAgentParam(AgentParam portBean) {
        this.dao.saveAgentParam(portBean);
        this.triggerUpdateTime();
    }

    public void addIpToFilter(String agentId, int type, String ip, String note) {
        AgentParam one = this.dao.findAgentParam(agentId);
        if (one != null) {
            IpFilterBean bean = new IpFilterBean(ip, note);
            if (type == 1) {
                Assert.isTrue((boolean)one.getIpFilterBlackSet().add(bean), (String)"\u6dfb\u52a0\u5931\u8d25,\u53ef\u80fd\u5df2\u5b58\u5728");
            } else if (type == 2) {
                Assert.isTrue((boolean)one.getIpFilterWhiteSet().add(bean), (String)"\u6dfb\u52a0\u5931\u8d25,\u53ef\u80fd\u5df2\u5b58\u5728");
            }
            this.dao.updateAgentParam(one);
            if (this.engine.hasAgent(agentId)) {
                DefaultAgentMeta meta = (DefaultAgentMeta)this.engine.getAgentMeta(agentId);
                if (type == 1) {
                    meta.getBlackIpSet().add(ip);
                } else if (type == 2) {
                    meta.getWhiteIpSet().add(ip);
                }
                this.engine.reApplyAgentMeta(agentId);
            }
        }
    }

    public void deleteAgentParam(String id) {
        this.dao.deleteAgentParam(id);
        this.triggerUpdateTime();
    }

    public void deleteIpFromFilter(String agentId, int type, String ip) {
        AgentParam one = this.dao.findAgentParam(agentId);
        if (one != null) {
            IpFilterBean remove = new IpFilterBean(ip, null);
            if (type == 1) {
                one.getIpFilterBlackSet().remove(remove);
            } else if (type == 2) {
                one.getIpFilterWhiteSet().remove(remove);
            }
            this.dao.updateAgentParam(one);
            if (this.engine.hasAgent(agentId)) {
                DefaultAgentMeta meta = (DefaultAgentMeta)this.engine.getAgentMeta(agentId);
                if (type == 1) {
                    meta.getBlackIpSet().remove(ip);
                } else if (type == 2) {
                    meta.getWhiteIpSet().remove(ip);
                }
                this.engine.reApplyAgentMeta(agentId);
            }
        }
    }

    public void disableHttpProtocol(String agentId, Boolean disableHttpProtocol) {
        AgentParam one = this.dao.findAgentParam(agentId);
        if (one != null) {
            one.setDisableHttpProtocol(disableHttpProtocol.booleanValue());
            this.dao.updateAgentParam(one);
            if (this.engine.hasAgent(agentId)) {
                try {
                    this.engine.updateAgentMeta((AgentMeta)this.transferAgentParam2AgentMeta(one));
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        }
    }

    public AgentInfoBean getAgentInfo(String agentId) {
        AgentParam input = this.dao.findAgentParam(agentId);
        if (input != null) {
            AgentInfoBean one = new AgentInfoBean();
            BeanUtils.copyProperties((Object)input, (Object)one);
            one.setActive(this.engine.hasAgent(one.getId()));
            one.setConnCount(this.engine.connectionCountUnderAgent(one.getId()));
            return one;
        }
        return null;
    }

    public Long getAgentParamLastUpdateTime() {
        return this.agentConfigLastUpdateTime;
    }

    public List<AgentParam> getAgentParamList() {
        return this.dao.findAgentParamList();
    }

    public void setAgentParamLastUpdateTime(Long time) {
        this.agentConfigLastUpdateTime = time;
    }

    public void setIpFilter(String agentId, int strategy) throws Exception {
        AgentParam agentParam = this.dao.findAgentParam(agentId);
        if (agentParam != null) {
            agentParam.setIpFilterStrategy(strategy);
            this.dao.updateAgentParam(agentParam);
            if (this.engine.hasAgent(agentId)) {
                DefaultAgentMeta meta = (DefaultAgentMeta)this.engine.getAgentMeta(agentId);
                meta.setIpFilterStrategy(strategy);
                this.engine.reApplyAgentMeta(agentId);
            }
        }
    }

    public boolean hasAgentParam(String newId) {
        return this.getAgentParam(newId) != null;
    }

    public boolean isAgentPortAvailable(Integer port, Integer destAgentType, String self) {
        if (port <= 0 || port >= 65535) {
            return false;
        }
        boolean rst = true;
        List configs = this.dao.findAgentParamByPort(port);
        if (!CollectionUtils.isEmpty((Collection)configs)) {
            for (AgentParam one : configs) {
                if (one.getId().equals(self) || one.getAgentPort().equals(port) && MakerUtils.getMaker((Integer)one.getAgentType()).supportPortShare().booleanValue() && one.getAgentType().equals(destAgentType)) continue;
                rst = false;
            }
        }
        return rst;
    }

    public boolean isContextPathAvailabel(Integer port, String localContext, String self) {
        boolean rst = true;
        List configs = this.dao.findAgentParamByPort(port);
        if (!CollectionUtils.isEmpty((Collection)configs)) {
            for (AgentParam one : configs) {
                if (one.getId().equals(self) || !Utils.fixContextPath((String)one.getAgentContext()).equalsIgnoreCase(Utils.fixContextPath((String)localContext))) continue;
                rst = false;
            }
        }
        return rst;
    }

    public Pagination<AgentInfoBean> getAgentInfoPage(AgentInfoBean portBean, Integer pageSize, Integer pageNo) {
        Pagination pagination = this.getAgentParamList(portBean, pageSize, pageNo);
        List dataList = Lists.transform((List)pagination.getList(), (Function)new /* Unavailable Anonymous Inner Class!! */);
        return new Pagination(Integer.valueOf(pagination.getPageNo()), Integer.valueOf(pagination.getPageSize()), pagination.getTotalCount(), dataList);
    }

    public Pagination<AgentParam> getAgentParamList(AgentInfoBean portBean, Integer pageSize, Integer pageNo) {
        List portBeans = this.dao.findAgentParamList(portBean, pageSize, pageNo);
        Pagination pagination = new Pagination(pageNo, pageSize, portBeans.size());
        pagination.setList(portBeans);
        return pagination;
    }

    public List<AgentInfoBean> getAgentInfoList() {
        List pagination = this.getAgentParamList();
        return Lists.transform((List)pagination, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public DataSwapStatus getDataSwapStatus() {
        return this.engine.getSwapStatus();
    }

    public void startAgent(String s) throws Exception {
        AgentParam agentParam = this.getAgentParam(s);
        if (agentParam != null) {
            this.engine.addAgent((AgentMeta)this.transferAgentParam2AgentMeta(agentParam));
        }
    }

    public AgentParam getAgentParam(String uuid) {
        return this.dao.findAgentParam(uuid);
    }

    public boolean isAgentRun(String agentId) {
        return this.engine.hasAgent(agentId);
    }

    public void stopAgent(String agentId) throws Exception {
        if (this.engine.hasAgent(agentId)) {
            this.engine.removeAgent(agentId);
        }
    }

    private void triggerUpdateTime() {
        this.setAgentParamLastUpdateTime(Long.valueOf(System.currentTimeMillis()));
    }

    public void updateAgentParam(AgentParam portBean) throws Exception {
        this.dao.updateAgentParam(portBean);
        if (this.engine.hasAgent(portBean.getId())) {
            DefaultAgentMeta serviceConfig = this.transferAgentParam2AgentMeta(portBean);
            this.engine.updateAgentMeta((AgentMeta)serviceConfig);
        }
        this.triggerUpdateTime();
    }

    private DefaultAgentMeta transferAgentParam2AgentMeta(AgentParam input) {
        DefaultAgentMeta one = new DefaultAgentMeta(input.getId(), input.getAgentType(), Boolean.valueOf(input.getRouteLocal() == 1), input.getAgentPort(), input.getAgentContext(), input.getDestHost(), input.getDestPort(), input.getDestContext(), input.isDisableHttpProtocol());
        one.setIpFilterStrategy(input.getIpFilterStrategy());
        Collections3.each((Collection)input.getIpFilterBlackSet(), (ICallback)new /* Unavailable Anonymous Inner Class!! */);
        Collections3.each((Collection)input.getIpFilterWhiteSet(), (ICallback)new /* Unavailable Anonymous Inner Class!! */);
        return one;
    }

    public List<DefaultAgentMeta> getAgentMetaList() {
        List agentServiceList = this.dao.findAgentParamList();
        return Lists.transform((List)agentServiceList, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ CSEngine access$000(AgentManagerImpl x0) {
        return x0.engine;
    }

    static /* synthetic */ DefaultAgentMeta access$100(AgentManagerImpl x0, AgentParam x1) {
        return x0.transferAgentParam2AgentMeta(x1);
    }
}

