/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.prs.action;

import com.google.common.collect.Maps;
import com.xdja.common.util.JsonResult;
import com.xdja.csagent.webui.base.action.BaseAction;
import com.xdja.csagent.webui.base.manager.AppPropConst;
import com.xdja.csagent.webui.base.manager.AppPropManager;
import com.xdja.csagent.webui.base.manager.AppPropType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="prsConfigAction")
@RequestMapping(value={"prs/config"})
public class ConfigAction
extends BaseAction {
    @Resource
    private AppPropManager appPropManager;

    @RequestMapping(value={"index"})
    public String index() {
        Integer networkLocation = this.appPropManager.findOne(AppPropConst.NETWORK_LOCATION).getInt();
        if (networkLocation != null && networkLocation > 0) {
            return "/prs/config/index";
        }
        return "redirect:/system/config/index.do";
    }

    @RequestMapping(value={"show"})
    @ResponseBody
    public JsonResult show() {
        try {
            HashMap rst = Maps.newHashMap();
            int networkLocation = this.appPropManager.findOne(AppPropConst.NETWORK_LOCATION).getInt();
            if (1 == networkLocation) {
                List tmp = this.appPropManager.findByType(new AppPropType[]{AppPropType.prs_base, AppPropType.prs_backend});
                rst.put("configList", tmp);
            } else if (2 == networkLocation) {
                List tmp = this.appPropManager.findByType(new AppPropType[]{AppPropType.prs_base, AppPropType.prs_frontend});
                rst.put("configList", tmp);
            } else {
                rst.put("configList", Collections.emptyList());
            }
            return JsonResult.success((Object)rst);
        }
        catch (Exception e) {
            this.logger.error("show prs integration config info error", (Throwable)e);
            return JsonResult.failure((String)e.getMessage());
        }
    }
}

