/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.prs.dao;

import com.xdja.csagent.webui.functions.prs.bean.AccessLogBean;
import com.xdja.csagent.webui.functions.prs.dao.AccessLogDao;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class AccessLogDao {
    private final BasicDataSource dataSource = new BasicDataSource();
    private NamedParameterJdbcTemplate jdbcTemplate;

    public AccessLogDao(AccessLogProp accessLogProps) {
        this.dataSource.setDriverClassName(accessLogProps.getDriverClassName());
        this.dataSource.setUrl(accessLogProps.getUrl());
        this.dataSource.setUsername(accessLogProps.getUsername());
        this.dataSource.setPassword(accessLogProps.getPassword());
        this.dataSource.setDefaultAutoCommit(true);
        this.dataSource.setInitialSize(1);
        this.dataSource.setMaxActive(3);
        this.dataSource.setMaxIdle(2);
        this.dataSource.setMinIdle(1);
        this.dataSource.setTestWhileIdle(true);
        this.dataSource.setValidationQuery("select 1");
        this.jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)this.dataSource);
    }

    public void clean() {
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            catch (SQLException e) {
                LoggerFactory.getLogger(AccessLogDao.class).info("Close AccessLog DataSource error", (Throwable)e);
            }
        }
    }

    public void storeToDb(AccessLogBean take) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into T_CS_ACCESS_LOG ");
        sql.append("(ID,AGENT_SERVICE_ID,ACCESS_USER_TYPE,ACCESS_USER,DEST_ADDRESS,IS_SUCCESS,NETWORK_FLOW,CONSUME_TIME,ACCESS_TIMESTAMP)");
        sql.append("values");
        sql.append("(:id,:agentServiceId,:accessUserType,:accessUser,:destAddress,:isSuccess,:networkFlow,:consumeTime,:accessTimestamp)");
        this.jdbcTemplate.update(sql.toString(), (SqlParameterSource)new BeanPropertySqlParameterSource((Object)take));
    }
}

