/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.prs.manager.impl;

import com.xdja.csagent.webui.functions.prs.bean.AccessLogBean;
import com.xdja.csagent.webui.functions.prs.dao.AccessLogDao;
import com.xdja.csagent.webui.functions.prs.manager.AccessLogManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogManagerImpl
implements AccessLogManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private LinkedBlockingQueue<AccessLogBean> queue = new LinkedBlockingQueue(10000);
    private ExecutorService executorService;
    private Future<?> future;
    private AccessLogDao accessLogDao;
    private final AccessLogDao.AccessLogProp accessLogProps;
    private volatile boolean isStop;

    public AccessLogManagerImpl(AccessLogDao.AccessLogProp accessLogProps) {
        this.accessLogProps = accessLogProps;
    }

    public boolean offer(AccessLogBean accessLogBean) {
        return this.queue.offer(accessLogBean);
    }

    public void shutdown() {
        this.isStop = true;
        if (this.accessLogDao != null) {
            this.accessLogDao.clean();
        }
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(true);
            this.future = null;
        }
        this.executorService.shutdownNow();
        this.executorService = null;
    }

    public boolean isRunning() {
        return this.executorService != null && !this.executorService.isTerminated();
    }

    public void startup() throws Exception {
        this.isStop = false;
        this.executorService = Executors.newSingleThreadExecutor();
        this.accessLogDao = new AccessLogDao(this.accessLogProps);
        this.future = this.executorService.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ LinkedBlockingQueue access$000(AccessLogManagerImpl x0) {
        return x0.queue;
    }

    static /* synthetic */ AccessLogDao access$100(AccessLogManagerImpl x0) {
        return x0.accessLogDao;
    }

    static /* synthetic */ boolean access$200(AccessLogManagerImpl x0) {
        return x0.isStop;
    }

    static /* synthetic */ Logger access$300(AccessLogManagerImpl x0) {
        return x0.logger;
    }
}

