/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.prs.plugins;

import com.xdja.common.util.JsonUtils;
import com.xdja.csagent.engine.Agent;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.engine.packet.Packet;
import com.xdja.csagent.engine.plugins.impl.ConnectionPluginAdapter;
import com.xdja.csagent.webui.functions.prs.PrsModuleStatus;
import com.xdja.csagent.webui.functions.prs.bean.AccessLogBean;
import com.xdja.csagent.webui.functions.prs.manager.AccessLogManager;
import com.xdja.csagent.webui.functions.prs.packet.AccessLogPacket;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.util.StringUtils;

public class AccessLogProcessPlugin
extends ConnectionPluginAdapter {
    private AccessLogManager storeService;
    private byte SUCCESS = 1;
    private byte FAILURE = 0;

    public AccessLogProcessPlugin(AccessLogManager storeService) {
        this.storeService = storeService;
    }

    private String getAccessUser(Map<String, Object> context) {
        return ObjectUtils.toString((Object)context.get("auth.identity"));
    }

    private String getAccessUserType(Map<String, Object> context) {
        return ObjectUtils.toString((Object)context.get("auth.identityType"));
    }

    public void onConnectOver(Agent agent, Map<String, Object> context, String destAddress, boolean success, long startTime, long endTime, int networkFlow) {
        AccessLogBean alb = new AccessLogBean();
        alb.setAgentServiceId(agent.getAgentMeta().getId());
        alb.setConsumeTime(Integer.valueOf((int)(endTime - startTime)));
        if (StringUtils.hasText((String)destAddress)) {
            if (destAddress.length() > 1010) {
                destAddress = destAddress.substring(0, 1000);
            }
            alb.setDestAddress(destAddress);
        }
        alb.setIsSuccess(Byte.valueOf(success ? this.SUCCESS : this.FAILURE));
        alb.setNetworkFlow(Integer.valueOf(networkFlow));
        if (context != null) {
            alb.setAccessUser(this.getAccessUser(context));
            alb.setAccessUserType(this.getAccessUserType(context));
        }
        alb.setAccessTimestamp(new Date(startTime));
        alb.setId(Utils.uuid());
        AccessLogPacket log = new AccessLogPacket();
        log.setPayload(JsonUtils.toJsonStr((Object)alb));
        PrsModuleStatus.AccessLog_GenerateCount.increment();
        if (this.storeService != null) {
            this.storeService.offer(alb);
        } else {
            agent.sendToRouteRemote((Packet)log);
        }
    }
}

