/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.prs.plugins;

import com.xdja.csagent.engine.Agent;
import com.xdja.csagent.engine.AgentMeta;
import com.xdja.csagent.engine.plugins.IConnectionPlugin;
import com.xdja.csagent.webui.functions.prs.PrsModuleStatus;
import com.xdja.prs.authentication.Configs;
import com.xdja.prs.authentication.IAuthenticate;
import com.xdja.prs.authentication.PrsAuthentication;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrsAuthenticationPlugin
implements IConnectionPlugin {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IAuthenticate authenticate;
    private PrsAuthentication prsAuthentication;

    public PrsAuthenticationPlugin(Configs configs) throws Exception {
        this.logger.info("initialize PrsAuthenticationPlugin");
        this.prsAuthentication = new PrsAuthentication(configs);
        this.authenticate = this.prsAuthentication.getAuthenticate();
    }

    public boolean activeIntercept(Channel channel, AgentMeta config, Map<String, Object> context) {
        boolean rst = false;
        if (config != null && config.getAgentType() == 1) {
            String address = ((InetSocketAddress)channel.remoteAddress()).getAddress().getHostAddress();
            Integer port = ((InetSocketAddress)channel.remoteAddress()).getPort();
            boolean pass = this.authenticate.authenticate(context, address, port.intValue(), new Object[]{config.getId(), context});
            rst = this.loggerAndReturn(channel, pass);
        }
        this.recordStatus(rst);
        return rst;
    }

    public void applyNewConfig(Channel channel, AgentMeta portConfig) {
    }

    public boolean httpRequestIntercept(Channel channel, AgentMeta config, Map<String, Object> context, String destHost, int destPort, String destPath) {
        boolean rst = false;
        if (config != null && config.getAgentType() == 2) {
            String address = ((InetSocketAddress)channel.remoteAddress()).getAddress().getHostAddress();
            Integer port = ((InetSocketAddress)channel.remoteAddress()).getPort();
            boolean pass = this.authenticate.authenticate(context, address, port.intValue(), new Object[]{config.getId()});
            rst = this.loggerAndReturn(channel, pass);
        }
        this.recordStatus(rst);
        return rst;
    }

    private void recordStatus(boolean rst) {
        if (rst) {
            PrsModuleStatus.Auth_AuthenticateFailureCount.increment();
        } else {
            PrsModuleStatus.Auth_AuthenticateSuccessCount.increment();
        }
    }

    private boolean loggerAndReturn(Channel channel, boolean pass) {
        if (pass) {
            this.logger.debug("prs authenticate pass !");
            return false;
        }
        this.logger.debug("prs authenticate failure !");
        channel.close();
        return true;
    }

    public void onConnectOver(Agent agent, Map<String, Object> context, String destAddress, boolean success, long startTime, long endTime, int networkFlow) {
    }

    public void onPluginDestroy() {
        if (this.prsAuthentication != null) {
            try {
                this.prsAuthentication.stop();
            }
            catch (Exception e) {
                this.logger.error("PrsAuthentication stop error!", (Throwable)e);
            }
            this.prsAuthentication = null;
        }
    }
}

