/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.prs.routeListener;

import com.xdja.common.util.JsonUtils;
import com.xdja.csagent.engine.AgentRoute;
import com.xdja.csagent.engine.IRoutePacketListener;
import com.xdja.csagent.engine.packet.Packet;
import com.xdja.csagent.webui.functions.prs.PrsModuleStatus;
import com.xdja.csagent.webui.functions.prs.bean.AccessLogBean;
import com.xdja.csagent.webui.functions.prs.manager.AccessLogManager;
import com.xdja.csagent.webui.functions.prs.packet.AccessLogPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogForwardPacketListener
implements IRoutePacketListener {
    public static final Logger LOGGER = LoggerFactory.getLogger(AccessLogForwardPacketListener.class);
    private final AccessLogManager storeService;

    public AccessLogForwardPacketListener(AccessLogManager storeService) throws Exception {
        this.storeService = storeService;
        if (!storeService.isRunning()) {
            storeService.startup();
        }
    }

    public boolean isReceive(Packet packet) {
        return packet instanceof AccessLogPacket;
    }

    public void init(AgentRoute route) {
    }

    public void close() {
        try {
            this.storeService.shutdown();
        }
        catch (Exception e) {
            LOGGER.error("AccessLogManager shutdown error!", (Throwable)e);
        }
    }

    public void onReceiveFromRoute(Packet packet, AgentRoute route) {
        AccessLogPacket log;
        AccessLogBean accessLogBean;
        PrsModuleStatus.AccessLog_ReceiveCount.increment();
        if (packet instanceof AccessLogPacket && (accessLogBean = (AccessLogBean)JsonUtils.readValue((String)(log = (AccessLogPacket)packet).getPayload(), AccessLogBean.class)) != null) {
            this.storeService.offer(accessLogBean);
        }
    }
}

