/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.prs.routeListener;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.xdja.common.util.JsonUtils;
import com.xdja.csagent.engine.AgentRoute;
import com.xdja.csagent.engine.IRoutePacketListener;
import com.xdja.csagent.engine.packet.Packet;
import com.xdja.csagent.webui.base.manager.AgentManager;
import com.xdja.csagent.webui.functions.prs.PrsModuleStatus;
import com.xdja.csagent.webui.functions.prs.packet.ConfigSyncPacket;
import com.xdja.csagent.webui.functions.prs.packet.LastUpdateTimeResp;
import com.xdja.csagent.webui.functions.prs.packet.UpdateConfigListReq;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSyncBackendPacketListener
implements IRoutePacketListener {
    private final AgentManager agentManager;
    private final int resouceSyncPeriod;
    ScheduledThreadPoolExecutor executorService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public ConfigSyncBackendPacketListener(AgentManager agentManager, int resouceSyncPeriod) {
        this.agentManager = agentManager;
        this.resouceSyncPeriod = resouceSyncPeriod;
    }

    public boolean isReceive(Packet packet) {
        return packet instanceof ConfigSyncPacket;
    }

    public void init(AgentRoute route) {
        this.executorService = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new DefaultThreadFactory("ConfigSyncBackend"));
        this.logger.info("SyncService startup , sync period is {} {}", (Object)this.resouceSyncPeriod, (Object)TimeUnit.MILLISECONDS.name());
        this.executorService.scheduleAtFixedRate((Runnable)new /* Unavailable Anonymous Inner Class!! */, 30000L, this.resouceSyncPeriod, TimeUnit.MILLISECONDS);
    }

    public void close() {
        this.executorService.shutdownNow();
        this.executorService = null;
    }

    public void onReceiveFromRoute(Packet packet, AgentRoute route) {
        this.logger.debug("\u6536\u5230\u6570\u636e\u5305{}", (Object)packet.getClass().getName());
        PrsModuleStatus.ResourceSync_ReceiveLastPacketTime.setTime(System.currentTimeMillis());
        this.executorService.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void processReceiveLastUpdateTime(LastUpdateTimeResp packet, AgentRoute route) throws JsonProcessingException {
        long remoteTime = packet.getLastUpdateTime();
        long localTime = this.agentManager.getAgentParamLastUpdateTime();
        PrsModuleStatus.ResourceSync_ResourceLastUpdateTime.setTime(localTime);
        if (localTime != remoteTime) {
            this.logger.info("\u672c\u5730\u4e0e\u8fdc\u7a0b\u66f4\u65b0\u65f6\u95f4\u4e0d\u4e00\u81f4\uff0c\u5f00\u59cb\u540c\u6b65\uff01local:{},remote:{}", (Object)localTime, (Object)remoteTime);
            List list = this.agentManager.getAgentParamList();
            String content = JsonUtils.toJsonStr((Object)list);
            UpdateConfigListReq req = new UpdateConfigListReq();
            req.setLastUpdateTime(Long.valueOf(localTime));
            req.setConfigListString(content);
            this.logger.debug("send UpdateConfigListReq({}) to frontend listener", (Object)list.size());
            route.send((Packet)req);
        } else {
            this.logger.debug("time same, no need update!");
        }
    }

    static /* synthetic */ Logger access$000(ConfigSyncBackendPacketListener x0) {
        return x0.logger;
    }

    static /* synthetic */ void access$100(ConfigSyncBackendPacketListener x0, LastUpdateTimeResp x1, AgentRoute x2) throws JsonProcessingException {
        x0.processReceiveLastUpdateTime(x1, x2);
    }
}

