/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.prs.routeListener;

import com.google.common.collect.Sets;
import com.xdja.common.util.Collections3;
import com.xdja.common.util.ICallback;
import com.xdja.csagent.engine.AgentRoute;
import com.xdja.csagent.engine.IRoutePacketListener;
import com.xdja.csagent.engine.packet.Packet;
import com.xdja.csagent.webui.base.entity.AgentParam;
import com.xdja.csagent.webui.base.manager.AgentManager;
import com.xdja.csagent.webui.functions.prs.PrsModuleStatus;
import com.xdja.csagent.webui.functions.prs.packet.ConfigSyncPacket;
import com.xdja.csagent.webui.functions.prs.packet.LastUpdateTimeReq;
import com.xdja.csagent.webui.functions.prs.packet.LastUpdateTimeResp;
import com.xdja.csagent.webui.functions.prs.packet.UpdateConfigListReq;
import com.xdja.csagent.webui.functions.prs.routeListener.ConfigSyncFrontendPacketListener;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSyncFrontendPacketListener
implements IRoutePacketListener {
    Logger log = LoggerFactory.getLogger(this.getClass());
    private AgentManager agentManager;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    public ConfigSyncFrontendPacketListener(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public boolean isReceive(Packet packet) {
        return packet instanceof ConfigSyncPacket;
    }

    public void init(AgentRoute route) {
    }

    public void close() {
        this.executorService.shutdownNow();
        this.executorService = null;
    }

    public void onReceiveFromRoute(Packet packet, AgentRoute route) {
        PrsModuleStatus.ResourceSync_ReceiveLastPacketTime.setTime(System.currentTimeMillis());
        if (packet instanceof LastUpdateTimeReq) {
            this.log.debug("receive LastUpdateTimeReq from backend listener");
            LastUpdateTimeResp bean = new LastUpdateTimeResp();
            Long lastUpdateTime = this.agentManager.getAgentParamLastUpdateTime();
            bean.setLastUpdateTime(lastUpdateTime);
            this.log.debug("send LastUpdateTimeResp to frontend listener : " + lastUpdateTime);
            route.send((Packet)bean);
        } else if (packet instanceof UpdateConfigListReq) {
            this.log.debug("receive UpdateConfigListReq from backend listener " + ((UpdateConfigListReq)packet).getLastUpdateTime());
            UpdateConfigListReq updateConfigListReq = (UpdateConfigListReq)packet;
            this.executorService.submit((Runnable)new UpdateTask(this, updateConfigListReq));
        }
    }

    private void updateConfigList(Long lastUpdateTime, List<AgentParam> configs) {
        HashSet newKeySet = Sets.newHashSet();
        Collections3.each(configs, (ICallback)new /* Unavailable Anonymous Inner Class!! */);
        List olds = this.agentManager.getAgentParamList();
        for (AgentParam one : olds) {
            String oldId = one.getId();
            try {
                if (newKeySet.contains(oldId)) continue;
                this.log.debug("delete agentService " + oldId);
                this.agentManager.deleteAgentParam(oldId);
            }
            catch (Exception e) {
                this.log.error("\u540c\u6b65\u529f\u80fd\uff0c\u5220\u9664\u4ee3\u7406\u670d\u52a1\u51fa\u9519!" + oldId);
            }
        }
        for (AgentParam one : configs) {
            String newId = one.getId();
            try {
                if (this.agentManager.hasAgentParam(newId)) {
                    this.log.debug("update agentService " + newId);
                    this.agentManager.updateAgentParam(one);
                } else {
                    this.log.debug("add agentService " + newId);
                    this.agentManager.addAgentParam(one);
                }
                if (one.getStatus() == 1) {
                    this.agentManager.startAgent(newId);
                    continue;
                }
                this.agentManager.stopAgent(newId);
            }
            catch (Exception e) {
                this.log.error("\u540c\u6b65\u529f\u80fd\uff0c\u589e\u52a0/\u66f4\u65b0\u4ee3\u7406\u670d\u52a1\u51fa\u9519!" + newId);
            }
        }
        this.agentManager.setAgentParamLastUpdateTime(lastUpdateTime);
        PrsModuleStatus.ResourceSync_ResourceLastUpdateTime.setTime(lastUpdateTime);
    }

    static /* synthetic */ AgentManager access$000(ConfigSyncFrontendPacketListener x0) {
        return x0.agentManager;
    }

    static /* synthetic */ void access$100(ConfigSyncFrontendPacketListener x0, Long x1, List x2) {
        x0.updateConfigList(x1, x2);
    }
}

