/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.setup.action;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.xdja.common.util.JsonResult;
import com.xdja.common.util.NetworkTester;
import com.xdja.common.util.Tuple;
import com.xdja.csagent.webui.base.bean.AppPropBean;
import com.xdja.csagent.webui.base.listener.CSAgentServer;
import com.xdja.csagent.webui.base.manager.AppPropManager;
import com.xdja.csagent.webui.functions.setup.bean.SetupBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SetupAction {
    @Resource
    private AppPropManager appPropManager;
    @Resource
    private CSAgentServer csAgentServer;
    private SetupBean setupBean;

    public void initSetupBean() {
        if (this.setupBean == null) {
            this.setupBean = new SetupBean();
            List all = this.appPropManager.findAll();
            HashMap values = Maps.newHashMap();
            for (AppPropBean one : all) {
                if (!StringUtils.hasText((String)one.getValue())) continue;
                values.put(one.getCode().toLowerCase(), one.getValue());
            }
            new BeanWrapperImpl((Object)this.setupBean).setPropertyValues((Map)values);
        }
    }

    @RequestMapping(value={"setup"}, method={RequestMethod.GET})
    public String setup(@RequestParam(value="step", required=false, defaultValue="base") String step, Model model) {
        this.initSetupBean();
        model.addAllAttributes((Map)BeanMap.create((Object)this.setupBean));
        return "/setup/" + step;
    }

    @RequestMapping(value={"setup"}, method={RequestMethod.POST})
    @ResponseBody
    public JsonResult setup(String step, @RequestParam(required=false, defaultValue="false") boolean check, SetupBean setup, HttpServletRequest request) {
        block22: {
            this.initSetupBean();
            try {
                if ("base".equals(step)) {
                    Assert.isTrue((boolean)Arrays.asList(1, 2).contains(setup.getNetwork_location()), (String)"\u7f51\u7edc\u4f4d\u7f6e");
                    Assert.isTrue((boolean)Arrays.asList(1, 2).contains(setup.getNetwork_channel_direction()), (String)"\u7f51\u95f8\u901a\u9053\u65b9\u5411");
                    Assert.isTrue((setup.getNetwork_channel_opposite_port() > 0 ? 1 : 0) != 0, (String)"\u7f51\u95f8\u901a\u9053\u7aef\u53e3");
                    Assert.hasText((String)setup.getNetwork_channel_opposite_ip(), (String)"\u7f51\u95f8\u5bf9\u7aefIP");
                    Assert.isTrue((setup.getSwap_request_max_interval_millis() > 0 ? 1 : 0) != 0, (String)"\u8f6e\u8be2\u5468\u671f\u4e0a\u9650");
                    Assert.isTrue((setup.getSwap_http_data_max_count() > 0 ? 1 : 0) != 0, (String)"\u6700\u591a\u643a\u5e26\u7684\u6570\u636e\u6761\u6570");
                    Assert.isTrue((setup.getAgent_connect_timeout_millis() > 0 ? 1 : 0) != 0, (String)"\u8fde\u63a5\u5efa\u7acb\u8d85\u65f6\u65f6\u957f");
                    Assert.isTrue((setup.getAgent_connection_idle_max_millis() > 0 ? 1 : 0) != 0, (String)"\u8fde\u63a5\u95f2\u7f6e\u65f6\u95f4\u4e0a\u9650");
                    Assert.isTrue((boolean)Arrays.asList(0, 1).contains(setup.getAgent_http_header_replace_enable()), (String)"\u662f\u5426\u542f\u7528HTTP Header\u4fe1\u606f\u66ff\u6362");
                    Assert.hasText((String)setup.getAgent_http_header_user_agent(), (String)"\u66ff\u6362\u540e\u7684User-Agent");
                    if (check) {
                        if (setup.getNetwork_location() == setup.getNetwork_channel_direction()) {
                            if (!NetworkTester.isLocalPortAvailable((int)setup.getNetwork_channel_opposite_port())) {
                                throw new RuntimeException("\u7aef\u53e3" + setup.getNetwork_channel_opposite_port() + "\u4e0d\u53ef\u7528");
                            }
                        } else if (!NetworkTester.connectDirectTest((String)setup.getNetwork_channel_opposite_ip(), (int)setup.getNetwork_channel_opposite_port(), (int)5)) {
                            throw new RuntimeException("\u5730\u5740" + setup.getNetwork_channel_opposite_ip() + ":" + setup.getNetwork_channel_opposite_port() + "\u8fde\u63a5\u4e0d\u901a");
                        }
                    } else {
                        this.setupBean.setNetwork_location(setup.getNetwork_location());
                        this.setupBean.setNetwork_channel_direction(setup.getNetwork_channel_direction());
                        this.setupBean.setNetwork_channel_opposite_port(setup.getNetwork_channel_opposite_port());
                        this.setupBean.setNetwork_channel_opposite_ip(setup.getNetwork_channel_opposite_ip());
                        this.setupBean.setSwap_http_data_max_count(setup.getSwap_http_data_max_count());
                        this.setupBean.setSwap_request_max_interval_millis(setup.getSwap_request_max_interval_millis());
                        this.setupBean.setAgent_connect_timeout_millis(setup.getAgent_connect_timeout_millis());
                        this.setupBean.setAgent_connection_idle_max_millis(setup.getAgent_connection_idle_max_millis());
                        this.setupBean.setAgent_http_header_replace_enable(setup.getAgent_http_header_replace_enable());
                        this.setupBean.setAgent_http_header_user_agent(setup.getAgent_http_header_user_agent());
                        if (this.setupBean.getIntegrate_prs_auth_sync_url().contains("{host}")) {
                            this.setupBean.setIntegrate_prs_auth_sync_url(this.setupBean.getIntegrate_prs_auth_sync_url().replace("{host}", this.setupBean.getNetwork_channel_opposite_ip()));
                        }
                    }
                    return JsonResult.success((Object)true);
                }
                if ("prs".equals(step)) {
                    Assert.isTrue((boolean)Arrays.asList(0, 1).contains(setup.getIntegrate_prs_enable()), (String)"\u662f\u5426\u542f\u7528PRS\u96c6\u6210\u6a21\u5757");
                    if (1 == this.setupBean.getNetwork_location()) {
                        if (setup.getIntegrate_prs_enable() == 1) {
                            Tuple pamsAvailable;
                            Tuple prsAvailable;
                            Tuple mdpAvailable;
                            Assert.isTrue((setup.getIntegrate_prs_resource_sync_period_millis() > 0 ? 1 : 0) != 0, (String)"\u8d44\u6e90\u914d\u7f6e\u540c\u6b65\u5468\u671f");
                            Assert.isTrue((setup.getIntegrate_prs_self_http_proxy_port() > 0 ? 1 : 0) != 0, (String)"\u5185\u90e8HttpProxy\u7aef\u53e3");
                            Assert.isTrue((setup.getIntegrate_prs_self_socks_proxy_port() > 0 ? 1 : 0) != 0, (String)"\u5185\u90e8SocksProxy\u7aef\u53e3");
                            Assert.hasText((String)setup.getIntegrate_prs_auth_mdp_jdbc_url(), (String)"MDP\u6570\u636e\u5e93\u5730\u5740");
                            Assert.hasText((String)setup.getIntegrate_prs_auth_mdp_jdbc_driver(), (String)"MDP\u6570\u636e\u5e93\u9a71\u52a8");
                            Assert.hasText((String)setup.getIntegrate_prs_auth_mdp_jdbc_username(), (String)"MDP\u6570\u636e\u5e93\u8d26\u53f7");
                            Assert.hasText((String)setup.getIntegrate_prs_auth_mdp_jdbc_password(), (String)"MDP\u6570\u636e\u5e93\u5bc6\u7801");
                            if (check && !((Boolean)(mdpAvailable = NetworkTester.isOracleJdbcAvailable((String)setup.getIntegrate_prs_auth_mdp_jdbc_url(), (String)setup.getIntegrate_prs_auth_mdp_jdbc_driver(), (String)setup.getIntegrate_prs_auth_mdp_jdbc_username(), (String)setup.getIntegrate_prs_auth_mdp_jdbc_password())).getA()).booleanValue()) {
                                throw new RuntimeException("MDP\u6570\u636e\u5e93\u914d\u7f6e\u4e0d\u53ef\u7528:" + (String)mdpAvailable.getB());
                            }
                            Assert.hasText((String)setup.getIntegrate_prs_auth_prs_jdbc_url(), (String)"PRS\u6570\u636e\u5e93\u5730\u5740");
                            Assert.hasText((String)setup.getIntegrate_prs_auth_prs_jdbc_driver(), (String)"PRS\u6570\u636e\u5e93\u9a71\u52a8");
                            Assert.hasText((String)setup.getIntegrate_prs_auth_prs_jdbc_username(), (String)"PRS\u6570\u636e\u5e93\u8d26\u53f7");
                            Assert.hasText((String)setup.getIntegrate_prs_auth_prs_jdbc_password(), (String)"PRS\u6570\u636e\u5e93\u5bc6\u7801");
                            if (check && !((Boolean)(prsAvailable = NetworkTester.isOracleJdbcAvailable((String)setup.getIntegrate_prs_auth_prs_jdbc_url(), (String)setup.getIntegrate_prs_auth_prs_jdbc_driver(), (String)setup.getIntegrate_prs_auth_prs_jdbc_username(), (String)setup.getIntegrate_prs_auth_prs_jdbc_password())).getA()).booleanValue()) {
                                throw new RuntimeException("PRS\u6570\u636e\u5e93\u914d\u7f6e\u4e0d\u53ef\u7528:" + (String)prsAvailable.getB());
                            }
                            Assert.hasText((String)setup.getIntegrate_prs_auth_pams_jdbc_url(), (String)"PAMS\u6570\u636e\u5e93\u5730\u5740");
                            Assert.hasText((String)setup.getIntegrate_prs_auth_pams_jdbc_driver(), (String)"PAMS\u6570\u636e\u5e93\u9a71\u52a8");
                            Assert.hasText((String)setup.getIntegrate_prs_auth_pams_jdbc_username(), (String)"PAMS\u6570\u636e\u5e93\u8d26\u53f7");
                            Assert.hasText((String)setup.getIntegrate_prs_auth_pams_jdbc_password(), (String)"PAMS\u6570\u636e\u5e93\u5bc6\u7801");
                            if (check && !((Boolean)(pamsAvailable = NetworkTester.isOracleJdbcAvailable((String)setup.getIntegrate_prs_auth_pams_jdbc_url(), (String)setup.getIntegrate_prs_auth_pams_jdbc_driver(), (String)setup.getIntegrate_prs_auth_pams_jdbc_username(), (String)setup.getIntegrate_prs_auth_pams_jdbc_password())).getA()).booleanValue()) {
                                throw new RuntimeException("PAMS\u6570\u636e\u5e93\u914d\u7f6e\u4e0d\u53ef\u7528:" + (String)pamsAvailable.getB());
                            }
                            Assert.hasText((String)setup.getIntegrate_prs_auth_sync_url(), (String)"\u9274\u6743\u6570\u636e\u540c\u6b65\u76ee\u6807URL");
                            Assert.isTrue((setup.getIntegrate_prs_auth_sync_period_millis() > 0 ? 1 : 0) != 0, (String)"\u9274\u6743\u6570\u636e\u540c\u6b65\u5468\u671f");
                            Assert.hasText((String)setup.getIntegrate_prs_auth_http_proxy_host(), (String)"\u9274\u6743\u6570\u636e\u540c\u6b65HttpProxy\u5730\u5740");
                            Assert.isTrue((setup.getIntegrate_prs_auth_http_proxy_port() > 0 ? 1 : 0) != 0, (String)"\u9274\u6743\u6570\u636e\u540c\u6b65HttpProxy\u7aef\u53e3");
                        }
                    } else if (2 == this.setupBean.getNetwork_location()) {
                        Assert.hasText((String)setup.getIntegrate_prs_auth_gateway_ip_list(), (String)"\u7f51\u5173\u5730\u5740\u5217\u8868");
                        Assert.hasText((String)setup.getIntegrate_prs_auth_gateway_port_list(), (String)"\u7f51\u5173\u5728\u7ebf\u60c5\u51b5\u67e5\u8be2\u7aef\u53e3\u5217\u8868");
                        Assert.isTrue((setup.getIntegrate_prs_auth_receive_gateway_port() > 0 ? 1 : 0) != 0, (String)"\u7f51\u5173\u4e0a\u4e0b\u7ebf\u4fe1\u606f\u63a5\u6536\u7aef\u53e3");
                        Assert.isTrue((setup.getIntegrate_prs_auth_receive_http_data_port() > 0 ? 1 : 0) != 0, (String)"\u9274\u6743\u4fe1\u606f\u63a5\u6536\u7aef\u53e3");
                        int gatewayIpSize = Iterables.size((Iterable)Splitter.on((String)",").omitEmptyStrings().split((CharSequence)setup.getIntegrate_prs_auth_gateway_ip_list()));
                        int gatewayPortSize = Iterables.size((Iterable)Splitter.on((String)",").omitEmptyStrings().split((CharSequence)setup.getIntegrate_prs_auth_gateway_port_list()));
                        Assert.isTrue((gatewayIpSize == gatewayPortSize ? 1 : 0) != 0, (String)"\u7f51\u5173\u5730\u5740\u4e0e\u7f51\u5173\u67e5\u8be2\u7aef\u53e3\u6570\u91cf\u4e0d\u4e00\u81f4");
                    }
                    if (!check) {
                        this.setupBean.setIntegrate_prs_enable(setup.getIntegrate_prs_enable());
                        this.setupBean.setIntegrate_prs_resource_sync_period_millis(setup.getIntegrate_prs_resource_sync_period_millis());
                        this.setupBean.setIntegrate_prs_self_http_proxy_port(setup.getIntegrate_prs_self_http_proxy_port());
                        this.setupBean.setIntegrate_prs_self_socks_proxy_port(setup.getIntegrate_prs_self_socks_proxy_port());
                        this.setupBean.setIntegrate_prs_auth_mdp_jdbc_url(setup.getIntegrate_prs_auth_mdp_jdbc_url());
                        this.setupBean.setIntegrate_prs_auth_mdp_jdbc_driver(setup.getIntegrate_prs_auth_mdp_jdbc_driver());
                        this.setupBean.setIntegrate_prs_auth_mdp_jdbc_username(setup.getIntegrate_prs_auth_mdp_jdbc_username());
                        this.setupBean.setIntegrate_prs_auth_mdp_jdbc_password(setup.getIntegrate_prs_auth_mdp_jdbc_password());
                        this.setupBean.setIntegrate_prs_auth_prs_jdbc_url(setup.getIntegrate_prs_auth_prs_jdbc_url());
                        this.setupBean.setIntegrate_prs_auth_prs_jdbc_driver(setup.getIntegrate_prs_auth_prs_jdbc_driver());
                        this.setupBean.setIntegrate_prs_auth_prs_jdbc_username(setup.getIntegrate_prs_auth_prs_jdbc_username());
                        this.setupBean.setIntegrate_prs_auth_prs_jdbc_password(setup.getIntegrate_prs_auth_prs_jdbc_password());
                        this.setupBean.setIntegrate_prs_auth_pams_jdbc_url(setup.getIntegrate_prs_auth_pams_jdbc_url());
                        this.setupBean.setIntegrate_prs_auth_pams_jdbc_driver(setup.getIntegrate_prs_auth_pams_jdbc_driver());
                        this.setupBean.setIntegrate_prs_auth_pams_jdbc_username(setup.getIntegrate_prs_auth_pams_jdbc_username());
                        this.setupBean.setIntegrate_prs_auth_pams_jdbc_password(setup.getIntegrate_prs_auth_pams_jdbc_password());
                        this.setupBean.setIntegrate_prs_auth_sync_url(setup.getIntegrate_prs_auth_sync_url());
                        this.setupBean.setIntegrate_prs_auth_sync_period_millis(setup.getIntegrate_prs_auth_sync_period_millis());
                        this.setupBean.setIntegrate_prs_auth_http_proxy_host(setup.getIntegrate_prs_auth_http_proxy_host());
                        this.setupBean.setIntegrate_prs_auth_http_proxy_port(setup.getIntegrate_prs_auth_http_proxy_port());
                        this.setupBean.setIntegrate_prs_auth_gateway_ip_list(setup.getIntegrate_prs_auth_gateway_ip_list());
                        this.setupBean.setIntegrate_prs_auth_gateway_port_list(setup.getIntegrate_prs_auth_gateway_port_list());
                        this.setupBean.setIntegrate_prs_auth_receive_gateway_port(setup.getIntegrate_prs_auth_receive_gateway_port());
                        this.setupBean.setIntegrate_prs_auth_receive_http_data_port(setup.getIntegrate_prs_auth_receive_http_data_port());
                    }
                    return JsonResult.success((Object)true);
                }
                if (!"over".equals(step)) break block22;
                this.appPropManager.updateSystemConfig(this.setupBean);
                this.appPropManager.markSetupOver();
                request.getSession().getServletContext().removeAttribute("needSetup");
                try {
                    this.csAgentServer.startup();
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(SetupAction.class).error("startup CSAgentServer error", (Throwable)e);
                }
                return JsonResult.success((Object)true);
            }
            catch (IllegalArgumentException e) {
                return JsonResult.failure((String)(e.getMessage() + " -> \u683c\u5f0f\u9519\u8bef,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u8f93\u5165!"));
            }
            catch (Exception e) {
                return JsonResult.failure((String)e.getMessage());
            }
        }
        return JsonResult.failure((String)"unknown");
    }
}

