/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.system.action;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.xdja.common.util.FreeworkDateEditor;
import com.xdja.common.util.JsonResult;
import com.xdja.csagent.webui.base.action.BaseAction;
import com.xdja.csagent.webui.base.manager.AppPropManager;
import com.xdja.csagent.webui.base.manager.AppPropType;
import com.xdja.csagent.webui.functions.system.manager.ImportAndExportManager;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller(value="baseConfigAction")
@RequestMapping(value={"system/config"})
public class ConfigAction
extends BaseAction {
    @Resource
    private AppPropManager appPropManager;
    @Resource
    private ImportAndExportManager importAndExportManager;

    @RequestMapping(value={"index"})
    public void index(Model model) {
    }

    @RequestMapping(value={"show"})
    @ResponseBody
    public JsonResult show() {
        try {
            HashMap rst = Maps.newHashMap();
            rst.put("configList", this.appPropManager.findByType(new AppPropType[]{AppPropType.app_base, AppPropType.app_optional}));
            return JsonResult.success((Object)rst);
        }
        catch (Exception e) {
            this.logger.error("show system config info error", (Throwable)e);
            return JsonResult.failure((String)e.getMessage());
        }
    }

    @RequestMapping(value={"uploadConfigFile"})
    @ResponseBody
    public JsonResult uploadConfigFile(MultipartFile configFile) {
        try {
            Assert.notNull((Object)configFile, (String)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isTrue((!configFile.isEmpty() ? 1 : 0) != 0, (String)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            this.importAndExportManager.importConfig(CharStreams.toString((Readable)new InputStreamReader(configFile.getInputStream(), Charsets.UTF_8)));
            return JsonResult.success((Object)configFile.getName());
        }
        catch (Exception e) {
            this.logger.error("update config file error!", (Throwable)e);
            return JsonResult.failure((String)e.getMessage());
        }
    }

    @RequestMapping(value={"exportConfigFile"})
    public void exportConfigFile(HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=\"" + FreeworkDateEditor.formatLongStr((Date)new Date()) + ".cson\"");
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        String content = this.importAndExportManager.exportConfig();
        writer.print(content);
        writer.flush();
    }
}

