/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.system.action;

import com.google.common.collect.Lists;
import com.xdja.common.util.JsonResult;
import com.xdja.common.util.ProgramInfo;
import com.xdja.csagent.engine.CSEngine;
import com.xdja.csagent.engine.bean.DataSwapStatus;
import com.xdja.csagent.webui.base.action.BaseAction;
import com.xdja.csagent.webui.base.listener.SystemPropertyInitListener;
import com.xdja.csagent.webui.functions.system.bean.InfoBean;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="baseInfoAction")
@RequestMapping(value={"system/info"})
public class InfoAction
extends BaseAction {
    @Value(value="${version}")
    private String version;
    @Resource
    private CSEngine agentServer;

    @RequestMapping(value={"index"})
    public void index() {
    }

    @RequestMapping(value={"show"})
    @ResponseBody
    public JsonResult show() {
        try {
            ArrayList rst = Lists.newArrayList();
            String baseType = "base";
            rst.add(new InfoBean("\u8f6f\u4ef6\u7248\u672c", this.version, baseType));
            rst.add(new InfoBean("Schema\u7248\u672c", "201512181323", baseType));
            rst.add(new InfoBean("\u5de5\u4f5c\u76ee\u5f55(csHome)", SystemPropertyInitListener.getCsHome(), baseType));
            rst.add(new InfoBean("\u64cd\u4f5c\u7cfb\u7edf", ProgramInfo.getOSnfo(), baseType));
            rst.add(new InfoBean("JAVA HOME", ProgramInfo.getJVMHome(), baseType));
            rst.add(new InfoBean("JAVA Vendor", ProgramInfo.getJVMVendor(), baseType));
            rst.add(new InfoBean("JAVA Version", ProgramInfo.getJVMVersion(), baseType));
            rst.add(new InfoBean("\u7ebf\u7a0b\u6570\u91cf", String.valueOf(ProgramInfo.getThreadCount()), baseType));
            rst.add(new InfoBean("\u5185\u5b58\u5360\u7528", ProgramInfo.getMemoryInfo(), baseType));
            rst.add(new InfoBean("\u8fd0\u884c\u65f6\u95f4", ProgramInfo.getUpTime(), baseType));
            rst.add(new InfoBean("PID", ProgramInfo.getPID(), baseType));
            rst.add(new InfoBean("\u672c\u673aIP", ProgramInfo.getIpInfo(), baseType));
            rst.add(new InfoBean("\u542f\u52a8\u7528\u6237", ProgramInfo.getOSUser(), baseType));
            String appType = "run";
            DataSwapStatus swapManager = this.agentServer.getSwapStatus();
            rst.add(new InfoBean("\u6570\u636e\u4ea4\u6362\u6a21\u5f0f", swapManager.getMode(), appType));
            boolean swapConnected = swapManager.getConnected();
            rst.add(new InfoBean("\u6570\u636e\u4ea4\u6362\u8fde\u63a5\u72b6\u6001", swapConnected ? "\u5df2\u8fde\u63a5" : "\u672a\u8fde\u63a5", appType));
            rst.add(new InfoBean("\u6570\u636e\u4ea4\u6362\u8fdc\u7a0b\u5730\u5740", swapManager.getRemoteAddress(), appType));
            rst.add(new InfoBean("\u6570\u636e\u4ea4\u6362\u672c\u5730\u5730\u5740", swapManager.getLocalAddress(), appType));
            return JsonResult.success((Object)rst);
        }
        catch (Exception e) {
            this.logger.error("show system status info error", (Throwable)e);
            return JsonResult.failure((String)e.getMessage());
        }
    }
}

