/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.system.action;

import com.google.common.collect.Lists;
import com.xdja.common.util.Collections3;
import com.xdja.common.util.ICallback;
import com.xdja.common.util.JsonUtils;
import com.xdja.common.util.page.Pagination;
import com.xdja.csagent.webui.base.action.BaseAction;
import com.xdja.csagent.webui.base.bean.UserBean;
import com.xdja.csagent.webui.base.entity.User;
import com.xdja.csagent.webui.functions.system.manager.UserManager;
import com.xdja.csagent.webui.security.MyPrincipal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UserAction
extends BaseAction {
    @Autowired
    private UserManager userManager;

    @RequestMapping(value={"/system/user/addOrEditUser"})
    @ResponseBody
    public String addOrEditUser(UserBean user, String roleId) {
        if (!StringUtils.hasText((String)user.getId())) {
            boolean available = this.userManager.isNameAvailable(user.getName(), null);
            if (!available) {
                return "doubleName";
            }
            this.userManager.addUser(user, roleId);
        } else {
            boolean available = this.userManager.isNameAvailable(user.getName(), user.getId());
            if (!available) {
                return "doubleName";
            }
            this.userManager.editUser(user, roleId);
        }
        return "success";
    }

    @RequestMapping(value={"/system/user/delUser"})
    @ResponseBody
    public boolean delUser(User user) {
        SecurityContext context = SecurityContextHolder.getContext();
        MyPrincipal principal = (MyPrincipal)context.getAuthentication().getPrincipal();
        if (principal.getUserId().equals(user.getId().toString())) {
            return false;
        }
        this.userManager.delUser(user.getId());
        return true;
    }

    @RequestMapping(value={"/system/user/getUserList"})
    public void getUserList(UserBean user, ModelMap map) {
    }

    @RequestMapping(value={"/system/user/loadMore"})
    @ResponseBody
    public Pagination queryPage(UserBean user, Integer pageSize, Integer pageNo) {
        return this.userManager.getUserList(user, pageSize, pageNo);
    }

    @RequestMapping(value={"/system/user/viewUser"})
    @ResponseBody
    public UserBean viewUser(UserBean user) {
        return this.userManager.viewUser(user);
    }

    @RequestMapping(value={"/system/user/toUserAuthority"})
    public void toRoleAuthority(String userId, ModelMap map) {
        ArrayList treeList = Lists.newArrayList();
        List resourceList = this.getMenuListService().findAllMenuList();
        Collections.sort(resourceList, new /* Unavailable Anonymous Inner Class!! */);
        Set auth = this.userManager.findUserAuth(userId);
        Collections3.each((Collection)resourceList, (ICallback)new /* Unavailable Anonymous Inner Class!! */);
        String jsonlist = JsonUtils.toJsonStr((Object)treeList);
        map.put((Object)"treeJson", (Object)jsonlist);
        UserBean user = new UserBean();
        user.setId(userId);
        UserBean userBean = this.userManager.viewUser(user);
        map.put((Object)"user", (Object)userBean);
    }

    @RequestMapping(value={"/system/user/saveUserAuthority"})
    @ResponseBody
    public boolean saveUserAuthority(@RequestParam(value="ids[]") List<String> ids, String userId) {
        this.userManager.replaceUserAuthority(userId, ids);
        return true;
    }
}

