/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.system.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xdja.common.util.JsonUtils;
import com.xdja.csagent.webui.base.entity.AgentParam;
import com.xdja.csagent.webui.base.manager.AgentManager;
import com.xdja.csagent.webui.functions.system.bean.v1.AgentParamV1;
import com.xdja.csagent.webui.functions.system.bean.v1.ExportConfigV1;
import com.xdja.csagent.webui.functions.system.bean.v1.TransformV1;
import com.xdja.csagent.webui.functions.system.manager.ImportAndExportManager;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ImportAndExportManagerImpl
implements ImportAndExportManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private AgentManager agentManager;

    public void importConfig(String config) throws Exception {
        JsonNode root = JsonUtils.mapper.readTree(config);
        String version = root.get("version").asText();
        if (ExportConfigV1.V.equalsIgnoreCase(version)) {
            ExportConfigV1 newConfig = (ExportConfigV1)JsonUtils.readValue((String)config, ExportConfigV1.class);
            for (AgentParamV1 one : newConfig.getAgentList()) {
                AgentParam old = this.agentManager.getAgentParam(one.getId());
                if (old != null) {
                    TransformV1.transform((AgentParamV1)one, (AgentParam)old);
                    this.agentManager.updateAgentParam(old);
                    this.logger.info("Update AgentParam " + old.getId());
                    continue;
                }
                AgentParam tmp = new AgentParam();
                TransformV1.transform((AgentParamV1)one, (AgentParam)tmp);
                this.agentManager.addAgentParam(tmp);
                this.logger.info("Add AgentParam " + tmp.getId());
            }
        } else {
            throw new IllegalArgumentException("unknown version : " + version);
        }
        this.logger.info("import config over ...");
    }

    public String exportConfig() {
        ExportConfigV1 export = new ExportConfigV1();
        export.setAgentList(Lists.transform((List)this.agentManager.getAgentParamList(), (Function)new /* Unavailable Anonymous Inner Class!! */));
        String rst = JsonUtils.toJsonStr((Object)export);
        return rst;
    }
}

