/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.security;

import com.xdja.csagent.webui.base.manager.MenuListService;
import com.xdja.csagent.webui.security.MyPrincipal;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;

public class MyAccessDecisionManager
implements AccessDecisionManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private MenuListService menuListService;

    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        if (!authentication.getClass().isAssignableFrom(UsernamePasswordAuthenticationToken.class)) {
            throw new AccessDeniedException("\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\uff01");
        }
        MyPrincipal principal = (MyPrincipal)authentication.getPrincipal();
        if ("superadmin".equals(principal.getUsername())) {
            this.logger.debug("ROOT user , all pass!");
            return;
        }
        String requestUrl = ((FilterInvocation)object).getRequestUrl();
        this.logger.debug("requestUrl is {}", (Object)requestUrl);
        int firstQuestionMarkIndex = requestUrl.indexOf("?");
        if (firstQuestionMarkIndex != -1) {
            requestUrl = requestUrl.substring(0, firstQuestionMarkIndex);
        }
        for (GrantedAuthority one : principal.getAuthorities()) {
            if (!one.getAuthority().equals(requestUrl)) continue;
            return;
        }
        if (this.menuListService.hasHref(requestUrl)) {
            throw new AccessDeniedException("\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\uff01");
        }
    }

    public boolean supports(ConfigAttribute arg0) {
        return true;
    }

    public boolean supports(Class<?> arg0) {
        return true;
    }
}

