/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.userLogs;

import com.xdja.csagent.webui.base.bean.OperateLogBean;
import com.xdja.csagent.webui.functions.system.manager.LogsUserManager;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.AsyncTaskExecutor;

public class AsyncLogsPersistQueueExecutor
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private LinkedBlockingQueue<OperateLogBean> queue = new LinkedBlockingQueue(10000);
    private AsyncTaskExecutor taskExecutor;
    private LogsUserManager manager;
    private Future<?> future;
    private static final int BATCH_SIZE = 50;

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setManager(LogsUserManager manager) {
        this.manager = manager;
    }

    public void start() {
        this.stop();
        this.future = this.taskExecutor.submit((Runnable)this);
    }

    public void stop() {
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(true);
        }
    }

    public boolean offer(OperateLogBean bean) {
        return this.queue.offer(bean);
    }

    @Override
    public void run() {
        try {
            ArrayList<OperateLogBean> params = new ArrayList<OperateLogBean>();
            while (true) {
                OperateLogBean one = (OperateLogBean)this.queue.take();
                params.add(one);
                if (!this.queue.isEmpty() && params.size() != 50) continue;
                this.manager.addLogs(params);
                params.clear();
            }
        }
        catch (InterruptedException e) {
            this.logger.info("\u5f02\u6b65\u65e5\u5fd7\u961f\u5217\u6301\u4e45\u5316\u6267\u884c\u4e2d\u65ad!");
        }
        catch (Exception e) {
            this.logger.error("\u5f02\u6b65\u65e5\u5fd7\u961f\u5217\u6301\u4e45\u5316\u6267\u884c\u5f02\u5e38!", (Throwable)e);
        }
    }
}

