
-- ----------------------------
-- Table structure for `t_logs_user`
-- ----------------------------
DROP TABLE IF EXISTS `t_logs_user`;
CREATE TABLE `t_logs_user` (
  `n_id` VARCHAR(50) NOT NULL  ,-- '编号，主键',
  `c_user_name` varchar(255) DEFAULT NULL ,-- '用户名',
  `c_class` varchar(255) DEFAULT NULL ,-- '类名',
  `c_method` varchar(255) DEFAULT NULL ,-- '方法名',
  `t_args` text ,-- '方法参数',
  `n_result` TINYINT DEFAULT NULL ,-- '执行结果,1成功,2出错',
  `t_note` text ,-- '备注,错误信息',
  `d_createtime` datetime DEFAULT NULL ,-- '执行时间,开始时间',
  `n_use_time` int DEFAULT NULL ,-- '耗时,毫秒',
  `c_uuid` varchar(50) DEFAULT NULL ,-- '执行唯一id',
  PRIMARY KEY (`n_id`)
);--='用户日志表';

-- ----------------------------
-- Table structure for `t_agent_param`
-- ----------------------------
DROP TABLE IF EXISTS `t_agent_param`;
CREATE TABLE `t_agent_param` (
  `n_id` VARCHAR(50) NOT NULL ,
  `t_json` CLOB NOT NULL,
  PRIMARY KEY (`n_id`)
);

-- ----------------------------
-- Table structure for `t_user`
-- ----------------------------
DROP TABLE IF EXISTS `t_user`;
CREATE TABLE `t_user` (
  `n_id` VARCHAR(50) NOT NULL  ,--  '编号，主键'
  `c_name` varchar(255) NOT NULL ,--  '用户名'
  `c_password` varchar(255) NOT NULL ,--  '密码（SHA-1）'
  `n_status` int DEFAULT NULL ,--  '1-正常；2-其他'
  `c_note` varchar(255) DEFAULT NULL ,--  '备注'
  PRIMARY KEY (`n_id`)
);-- ='用户表';

DROP TABLE IF EXISTS `t_user_menu`;
CREATE TABLE `t_user_menu` (
  `n_id` VARCHAR(50) NOT NULL  ,-- '编号，主键'
  `n_user_id` VARCHAR(50) DEFAULT NULL ,--  '用户id，对应t_user主键'
  `n_menu_id` VARCHAR(50) DEFAULT NULL ,--  '菜单id'
  PRIMARY KEY (`n_id`)
);-- ='用户菜单表';

DROP TABLE IF EXISTS `t_sql_version`;
CREATE TABLE `t_sql_version` (
  `version_id` VARCHAR(50) NOT NULL  ,-- '编号，主键'
  `version_time` datetime NOT NULL ,--  '用户id，对应t_user主键'
  PRIMARY KEY (`version_id`)
);-- ='数据库版本号';


INSERT INTO `t_user_menu` VALUES ('16', '2','01');
INSERT INTO `t_user_menu` VALUES ('17', '2','01-05');
INSERT INTO `t_user_menu` VALUES ('18', '2','01-05-001');
INSERT INTO `t_user_menu` VALUES ('19', '2','01-05-010');
INSERT INTO `t_user_menu` VALUES ('29', '2','01-05-020');
INSERT INTO `t_user_menu` VALUES ('30', '2','01-05-030');

-- ----------------------------
-- Records of t_user
-- ----------------------------
INSERT INTO `t_user` VALUES ('1', 'superadmin', '562dccbf0c3c7f58ce13cb2c352b8e04a7b079ff', '1', '管理员');
INSERT INTO `t_user` VALUES ('2', 'admin', '260acbffd3c30786febc29d7dd71a9880a811e77', '1', '用户');--123456