window.console = window.console || {
        log: function () {
        }
    };

String.prototype.trim = function () {
    var str = this,
        str = str.replace(/^\s\s*/, ''),
        ws = /\s/,
        i = str.length;
    while (ws.test(str.charAt(--i)));
    return str.slice(0, i + 1);
}

/*
 * 检查url
 */
function checkUrl(str_url) {
    var strRegex = "^((https|http|ftp|rtsp|mms)?://)"
        + "(([0-9a-z_!~*'().&=+$%-]+: )?[0-9a-z_!~*'().&=+$%-]+@)?" //ftp的user@
        + "(([0-9]{1,3}\.){3}[0-9]{1,3}" // IP形式的URL- 199.194.52.184
        + "|" // 允许IP和DOMAIN（域名）
        + "([0-9a-z_!~*'()-]+\.)*" // 域名- www.
        + "([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\." // 二级域名
        + "[a-z]{2,6})" // first level domain- .com or .museum
        + "(:[0-9]{1,4})?" // 端口- :80
        + "((/?)|" // a slash isn't required if there is no file name
        + "(/[0-9a-z_!~*'().;?:@&=+$,%#-]+)+/?)$";
    var re = new RegExp(strRegex);
    //re.test()
    if (re.test(str_url)) {
        return (true);
    } else {
        return (false);
    }
}

/*
 * 检查ip地址
 */
function checkIp(ip) {
    var re = /(\d+)\.(\d+)\.(\d+)\.(\d+)$/g;
    if (re.test(ip)) {
        if (RegExp.$1 < 256 && RegExp.$2 < 256 && RegExp.$3 < 256 && RegExp.$4 < 256)
            return true;
    }
    return false;
}

function checkPort(port) {
    var reg = /^([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]{1}|6553[0-5])$/;
    return reg.test(port);
}

/**
 * 时间对象的格式化;
 */
Date.prototype.format = function (format) {
    /*
     * eg:format="YYYY-MM-dd hh:mm:ss";
     */
    var o = {
        "M+": this.getMonth() + 1, // month
        "d+": this.getDate(), // day
        "H+": this.getHours(), // hour
        "m+": this.getMinutes(), // minute
        "s+": this.getSeconds(), // second
        "q+": Math.floor((this.getMonth() + 3) / 3), // quarter
        "S": this.getMilliseconds()
        // millisecond
    }

    if (/(y+)/.test(format)) {
        format = format.replace(RegExp.$1, (this.getFullYear() + "")
            .substr(4 - RegExp.$1.length));
    }

    for (var k in o) {
        if (new RegExp("(" + k + ")").test(format)) {
            format = format.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k]
                : ("00" + o[k]).substr(("" + o[k]).length));
        }
    }
    return format;
};
//全局的ajax访问异常提示
$.ajaxSetup({
    contentType: "application/x-www-form-urlencoded;charset=utf-8",
    complete: function (resp, textStatus) {
        if (resp.status != 200) {
            if (resp.status == 403) {
                alert("系统内部错误，请重新登陆!\r\n");
            } else if (resp.status < 500 && resp.status >= 400) {
                alert("请求出错!\r\n" + resp.responseText);
            } else if (resp.status >= 500) {
                alert("服务器异常!\r\n" + resp.responseText);
            }
        }
    }
});
$.extend({
    postAndWait: function (url, params, title) {
        if (!title) {
            title = "loading";
        }
        dialog({
            id: 'post_and_wait_id',
            title: title,
            cancel: false,
            fixed: true
        }).showModal();
        var ajax = $.post(url, params)
            .done(function () {
                dialog.get("post_and_wait_id").close().remove();
            }).fail(function () {
                dialog.get("post_and_wait_id").close().remove();
            });
        return ajax;
    },
    tips: function (str, func) {
        var ps = {
            content: str,
            ok: function () {
            }
        };
        if (func) {
            ps.ok = func;
        }
        dialog(ps).showModal();
    },
    confirm: function (str, func) {
        var ps = {
            content: str,
            cancelValue: '取消',
            cancel: function () {
            },
            okValue: '确定',
            ok: function () {
                if (func) {
                    func();
                }
            }
        };
        dialog(ps).showModal();
    }
});