/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.common.util;

import java.util.Collection;

public class JsonResult<T> {
    private int code;
    private long total;
    private T data;
    private Object children;
    private String msg;

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    private JsonResult() {
    }

    public Object getChildren() {
        return this.children;
    }

    public void setChildren(Object children) {
        this.children = children;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public static <T> JsonResult<T> success(T data) {
        JsonResult tJsonResult = new JsonResult();
        tJsonResult.setCode(1);
        tJsonResult.setData(data);
        return tJsonResult;
    }

    public static JsonResult failure(String message) {
        JsonResult tJsonResult = new JsonResult();
        tJsonResult.setCode(0);
        tJsonResult.setData((Object)message);
        tJsonResult.setMsg(message);
        return tJsonResult;
    }

    public static JsonResult gridData(long total, Collection data) {
        JsonResult jr = new JsonResult();
        jr.setCode(1);
        jr.setTotal(total);
        jr.setData((Object)data);
        return jr;
    }

    public static JsonResult gridData(long total, Object[] data) {
        JsonResult jr = new JsonResult();
        jr.setTotal(total);
        jr.setData((Object)data);
        return jr;
    }

    public static JsonResult treeData(Collection data) {
        JsonResult tJsonResult = new JsonResult();
        tJsonResult.setCode(1);
        tJsonResult.setChildren((Object)data);
        return tJsonResult;
    }

    public boolean isSuccess() {
        return this.code == 1;
    }

    public T getData() {
        return (T)this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}

