/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.common.util;

import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProgramInfo {
    public static String getOSnfo() {
        Properties props = System.getProperties();
        String rst = String.format("%s | %s | %s", props.getProperty("os.name"), props.getProperty("os.arch"), props.getProperty("os.version"));
        return rst;
    }

    public static String getJVMVendor() {
        Properties props = System.getProperties();
        String javaVendor = props.getProperty("java.vendor");
        return javaVendor;
    }

    public static String getJVMVersion() {
        Properties props = System.getProperties();
        String javaVersion = props.getProperty("java.version");
        return javaVersion;
    }

    public static String getJVMHome() {
        Properties props = System.getProperties();
        String javaHome = props.getProperty("java.home");
        return javaHome;
    }

    public static String getCPUInfo() {
        return Runtime.getRuntime().availableProcessors() + "";
    }

    public static String getMemoryInfo() {
        Runtime r = Runtime.getRuntime();
        int mUnit = 0x100000;
        String rst = String.format("(%s/%s)m", r.totalMemory() / (long)mUnit, r.maxMemory() / (long)mUnit);
        return rst;
    }

    public static String getPID() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            return name.split("@")[0];
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getUpTime() {
        long diff = ManagementFactory.getRuntimeMXBean().getUptime();
        long diffSeconds = diff / 1000L % 60L;
        long diffMinutes = diff / 60000L % 60L;
        long diffHours = diff / 3600000L % 24L;
        long diffDays = diff / 86400000L;
        StringBuffer sb = new StringBuffer();
        if (diffDays > 0L) {
            sb.append(diffDays);
            sb.append("\u5929");
        }
        if (diffHours > 0L) {
            sb.append(diffHours);
            sb.append("\u65f6");
        }
        if (diffMinutes > 0L) {
            sb.append(diffMinutes);
            sb.append("\u5206");
        }
        sb.append(diffSeconds);
        sb.append("\u79d2");
        return sb.toString();
    }

    public static int getThreadCount() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    public static String getIpInfo() {
        return ProgramInfo.getAllLocalHostIP().toString();
    }

    public static String getOSUser() {
        Properties props = System.getProperties();
        return props.getProperty("user.name");
    }

    public static List<String> getAllLocalHostIP() {
        ArrayList ips = Lists.newArrayList();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                if (null == netint.getHardwareAddress()) continue;
                List<InterfaceAddress> list = netint.getInterfaceAddresses();
                for (InterfaceAddress interfaceAddress : list) {
                    String localip = interfaceAddress.getAddress().toString();
                    ips.add(localip);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return ips;
    }
}

