/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.common.util.page;

public class SimplePage {
    public static final int PAGE_SIZE = 20;
    protected int totalCount = 0;
    protected int pageSize = 20;
    protected int pageNo = 1;

    public SimplePage() {
    }

    public SimplePage(Integer pageNo, Integer pageSize, int totalCount) {
        this.setTotalCount(totalCount);
        this.setPageSize(pageSize);
        this.setPageNo(pageNo);
        this.adjustPageNo();
    }

    public void adjustPageNo() {
        if (this.pageNo == 1) {
            return;
        }
        int tp = this.getTotalPage();
        if (this.pageNo > tp) {
            this.pageNo = tp;
        }
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getTotalPage() {
        int totalPage = this.totalCount / this.pageSize;
        if (totalPage == 0 || this.totalCount % this.pageSize != 0) {
            ++totalPage;
        }
        return totalPage;
    }

    public boolean isFirstPage() {
        return this.pageNo <= 1;
    }

    public boolean isLastPage() {
        return this.pageNo >= this.getTotalPage();
    }

    public int getNextPage() {
        if (this.isLastPage()) {
            return this.pageNo;
        }
        return this.pageNo + 1;
    }

    public int getPrePage() {
        if (this.isFirstPage()) {
            return this.pageNo;
        }
        return this.pageNo - 1;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount < 0 ? 0 : totalCount;
    }

    public void setPageSize(Integer pageSize) {
        if (pageSize != null && pageSize >= 1) {
            this.pageSize = pageSize;
        }
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo == null || pageNo < 1 ? 1 : pageNo;
    }
}

