/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.base.listener;

import com.xdja.csagent.webui.base.listener.CSAgentServer;
import com.xdja.csagent.webui.base.manager.AppPropManager;
import java.awt.Desktop;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.FrameworkServlet;

public class AppInitialization
extends HttpServlet {
    public static final String NEED_SETUP = "needSetup";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private CSAgentServer CSAgentServer;

    public void destroy() {
        if (this.CSAgentServer != null) {
            try {
                this.CSAgentServer.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.destroy();
    }

    public void init() throws ServletException {
        super.init();
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext(), (String)(FrameworkServlet.SERVLET_CONTEXT_PREFIX + "mvc"));
        AppPropManager propManager = (AppPropManager)wac.getBean(AppPropManager.class);
        try {
            propManager.initConfigItem();
        }
        catch (Exception e) {
            throw new ServletException("init app property config file error", (Throwable)e);
        }
        try {
            if (propManager.isSystemConfigReady()) {
                this.CSAgentServer = (CSAgentServer)wac.getBean(CSAgentServer.class);
                this.CSAgentServer.startup();
            } else {
                this.getServletContext().setAttribute(NEED_SETUP, (Object)true);
                String setupUrl = this.getServletContext().getContextPath() + "/setup.do";
                this.logger.info("\u914d\u7f6e\u4fe1\u606f\u4e0d\u53ef\u7528,\u6682\u4e0d\u542f\u52a8CSAgentServer,\u8fdb\u5165\u5f15\u5bfc\u7528\u6237\u914d\u7f6e\u6a21\u5f0f,\u914d\u7f6e\u5730\u5740:{}", (Object)setupUrl);
                this.tryBrowseSetup(setupUrl);
            }
        }
        catch (Exception e) {
            this.logger.warn("CSAgent Start Failure !!!!!!", (Throwable)e);
        }
        this.logger.info("############# application init over ############");
    }

    private void tryBrowseSetup(String setupUrl) {
        try {
            int tomcatConnectorPort = this.getTomcatConnectorPort();
            if (tomcatConnectorPort > 0 && Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI("http://localhost:" + tomcatConnectorPort + setupUrl));
            }
        }
        catch (Exception e) {
            this.logger.warn("try browse Setup failure ! " + e.getMessage());
        }
    }

    int getTomcatConnectorPort() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> objs = mbs.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
            Iterator<ObjectName> objectNameIterator = objs.iterator();
            if (objectNameIterator.hasNext()) {
                ObjectName obj = objectNameIterator.next();
                String port = obj.getKeyProperty("port");
                return Integer.parseInt(port);
            }
        }
        catch (MalformedObjectNameException e) {
            this.logger.warn("try acquire tomcat connector local port failure ! " + e.getMessage());
        }
        return 0;
    }
}

