/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.base.listener;

import com.xdja.csagent.dataswap.core.SwapConfig;
import com.xdja.csagent.dataswap.core.SwapManager;
import com.xdja.csagent.engine.AgentMeta;
import com.xdja.csagent.engine.CSEngine;
import com.xdja.csagent.engine.IWidget;
import com.xdja.csagent.engine.bean.EngineParams;
import com.xdja.csagent.engine.plugins.IConnectionPlugin;
import com.xdja.csagent.webui.base.bean.DefaultAgentMeta;
import com.xdja.csagent.webui.base.manager.AgentManager;
import com.xdja.csagent.webui.base.manager.AppPropConst;
import com.xdja.csagent.webui.base.manager.AppPropManager;
import com.xdja.csagent.webui.base.plugins.IpIntercepterPlugin;
import com.xdja.csagent.webui.functions.prs.PrsIntegration;
import java.util.Collections;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CSAgentServer
implements IWidget<Void> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AgentManager agentManager;
    @Autowired
    private CSEngine csEngine;
    @Resource
    private AppPropManager appPropManager;
    @Resource
    private PrsIntegration prsIntegration;

    public void shutdown() {
        this.logger.info("^\u505c\u6b62 CSAgentServer!");
        this.csEngine.shutdown();
        this.logger.info("$\u505c\u6b62 CSAgentServer!");
    }

    public boolean isRunning() {
        return this.csEngine.isRunning();
    }

    public Void startup() throws Exception {
        if (this.isRunning()) {
            this.logger.info("CSAgentServer is running!!!");
        } else {
            this.logger.info("start CSAgentServer");
            this.initEngineParams(this.csEngine.getEngineParams());
            this.initSwapConfig(this.csEngine.getSwapConfig());
            this.csEngine.startup();
            this.csEngine.addConnectionPlugin((IConnectionPlugin)new IpIntercepterPlugin());
            if (this.appPropManager.findOne(AppPropConst.INTEGRATE_PRS_ENABLE).getInt() == 1) {
                this.logger.info("enable integrate prs");
                this.prsIntegration.config(this.agentManager, this.csEngine);
            } else {
                this.logger.info("disable integrate prs");
            }
            for (DefaultAgentMeta one : this.agentManager.getAgentMetaList()) {
                this.csEngine.addAgent((AgentMeta)one);
            }
            this.logger.info("###################################################");
            this.logger.info("####### CSAgent Service Start Success !!!! ########");
            this.logger.info("###################################################");
        }
        return null;
    }

    private EngineParams initEngineParams(EngineParams engineParams) {
        engineParams.setHttpHeaderReplaceEnable(Boolean.valueOf(this.appPropManager.findOne(AppPropConst.AGENT_HTTP_HEADER_REPLACE_ENABLE).getInt() == 1));
        engineParams.getHttpHeaderReplaceMap().put("User-Agent", this.appPropManager.findOne(AppPropConst.AGENT_HTTP_HEADER_USER_AGENT).getValue());
        engineParams.setConnectTimeoutMillis(this.appPropManager.findOne(AppPropConst.AGENT_CONNECT_TIMEOUT_MILLIS).getInt());
        engineParams.setConnectIdleMillis(this.appPropManager.findOne(AppPropConst.AGENT_CONNECTION_IDLE_MAX_MILLIS).getInt());
        return engineParams;
    }

    private SwapConfig initSwapConfig(SwapConfig swapConfig) {
        Integer communicationType = this.appPropManager.findOne(AppPropConst.COMMUNICATION_TYPE).getInt();
        Assert.isTrue((communicationType != null ? 1 : 0) != 0, (String)(AppPropConst.COMMUNICATION_TYPE.name() + " not set!"));
        swapConfig.setCommunicationType(communicationType.intValue());
        Integer networkLocation = this.appPropManager.findOne(AppPropConst.NETWORK_LOCATION).getInt();
        Integer networkDirection = this.appPropManager.findOne(AppPropConst.NETWORK_CHANNEL_DIRECTION).getInt();
        Assert.isTrue((networkLocation != null && networkLocation > 0 ? 1 : 0) != 0, (String)(AppPropConst.NETWORK_LOCATION.name() + " not set!"));
        if (!networkLocation.equals(networkDirection)) {
            swapConfig.setManagerMode(SwapManager.Mode.Client);
        } else {
            swapConfig.setManagerMode(SwapManager.Mode.Server);
        }
        String destHost = this.appPropManager.findOne(AppPropConst.NETWORK_DEST_HOST).getValue();
        Integer destPort = this.appPropManager.findOne(AppPropConst.NETWORK_DEST_PORT).getInt();
        String destUsername = this.appPropManager.findOne(AppPropConst.NETWORK_DEST_USERNAME).getValue();
        String destPassword = this.appPropManager.findOne(AppPropConst.NETWORK_DEST_PASSWORD).getValue();
        Integer srcPort = this.appPropManager.findOne(AppPropConst.NETWORK_SRC_PORT).getInt();
        Integer localPort = this.appPropManager.findOne(AppPropConst.NETWORK_LOCAL_PORT).getInt();
        String localUsername = this.appPropManager.findOne(AppPropConst.NETWORK_LOCAL_USERNAME).getValue();
        String localPassword = this.appPropManager.findOne(AppPropConst.NETWORK_LOCAL_PASSWORD).getValue();
        swapConfig.setDestHost(destHost);
        swapConfig.setDestPort(destPort.intValue());
        swapConfig.setDestUsername(destUsername);
        swapConfig.setDestPassword(destPassword);
        swapConfig.setSrcPort(srcPort.intValue());
        swapConfig.setLocalPort(localPort.intValue());
        swapConfig.setLocalAccounts(Collections.singletonMap(localUsername, localPassword));
        swapConfig.setHttpRequestInterval(this.appPropManager.findOne(AppPropConst.SWAP_REQUEST_MAX_INTERVAL_MILLIS).getInt().intValue());
        swapConfig.setHttpDataCountMax(this.appPropManager.findOne(AppPropConst.SWAP_HTTP_DATA_MAX_COUNT).getInt().intValue());
        return swapConfig;
    }
}

