/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.base.listener;

import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import com.xdja.csagent.webui.base.listener.SystemPropertyInitListener;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Driver;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class H2Helper {
    public static final String NEW_VERSION = "201512181323";
    static final Logger logger = LoggerFactory.getLogger(H2Helper.class);
    private static String JDBC_H2_FILE_CSAGENT_CONFIG;

    public static String getH2JdbcUrl() {
        return JDBC_H2_FILE_CSAGENT_CONFIG;
    }

    public static void initDatabase() throws Exception {
        List versions;
        String version;
        String csHome = SystemPropertyInitListener.getCsHome();
        JDBC_H2_FILE_CSAGENT_CONFIG = "jdbc:h2:file:" + csHome + "/conf/sys";
        Driver aClass = (Driver)Class.forName("org.h2.Driver").newInstance();
        logger.info("use jdbc url [{}]", (Object)JDBC_H2_FILE_CSAGENT_CONFIG);
        SimpleDriverDataSource sdds = new SimpleDriverDataSource(aClass, JDBC_H2_FILE_CSAGENT_CONFIG, "sa", "");
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)sdds);
        String ddlSql = H2Helper.loadInnerSql();
        Number number = (Number)jdbcTemplate.queryForObject("select count(1) from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA='PUBLIC' and TABLE_NAME='T_SQL_VERSION'", Number.class);
        if (number.intValue() > 0 && StringUtils.hasText((String)(version = (String)Iterables.getFirst((Iterable)(versions = jdbcTemplate.queryForList("select version_id from t_sql_version limit 1 offset 0", String.class)), null)))) {
            if ("201512181323".equals(version)) {
                logger.info("current database schema is latest! 201512181323");
                return;
            }
            logger.warn("current database schema is {}!", (Object)version);
        }
        logger.warn("prepare update database schema to {}!", (Object)"201512181323");
        try {
            jdbcTemplate.execute(ddlSql);
            jdbcTemplate.update("INSERT INTO `t_sql_version` VALUES ('201512181323',NOW())");
            logger.warn("update database schema success !");
        }
        catch (Exception e) {
            logger.error("replace database schema failure! error message is {}", (Object)e.getMessage());
            throw e;
        }
    }

    private static String loadInnerSql() throws IOException {
        URL resource = H2Helper.class.getResource("/h2ddl/csagent.sql");
        logger.info("current use database schemal location is [{}]", (Object)resource.toString());
        return Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
    }
}

