/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.base.manager.impl;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.xdja.csagent.webui.base.bean.AppPropBean;
import com.xdja.csagent.webui.base.listener.SystemPropertyInitListener;
import com.xdja.csagent.webui.base.manager.AppPropConst;
import com.xdja.csagent.webui.base.manager.AppPropManager;
import com.xdja.csagent.webui.base.manager.AppPropType;
import com.xdja.csagent.webui.base.utils.TestConfigTools;
import com.xdja.csagent.webui.functions.setup.bean.SetupBean;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class AppPropManagerImpl
implements AppPropManager {
    public static final String CFG_FILE = new File(SystemPropertyInitListener.getCsHome(), "conf/csagent.xml").getAbsolutePath();
    private Logger logger = LoggerFactory.getLogger(AppPropManagerImpl.class);
    private XMLConfiguration cfg;

    public void addOne(AppPropBean one) {
        try {
            this.addNewItem(this.cfg, one.getValue(), one.getCode(), one.getDesc(), one.getNote());
            this.cfg.save(CFG_FILE);
        }
        catch (ConfigurationException e) {
            this.logger.error("add system property error", (Throwable)e);
        }
    }

    public void initConfigItem() throws Exception {
        this.logger.info("initialize config items ...");
        this.checkTestConfigFile();
        File file = new File(CFG_FILE);
        if (!file.exists()) {
            this.logger.info("creating file : {} ", (Object)CFG_FILE);
            XMLConfiguration tmp = new XMLConfiguration();
            tmp.setEncoding(Charsets.UTF_8.name());
            tmp.setRootElementName("csagent");
            tmp.save(CFG_FILE);
        }
        this.cfg = new XMLConfiguration();
        this.cfg.setEncoding(Charsets.UTF_8.name());
        this.cfg.setAttributeSplittingDisabled(true);
        this.cfg.setDelimiterParsingDisabled(true);
        this.cfg.load(CFG_FILE);
        HashMap itemMap = Maps.newHashMap();
        for (HierarchicalConfiguration one : this.cfg.configurationsAt("item")) {
            String code = one.getString("[@code]");
            itemMap.put(code, one);
        }
        for (AppPropConst one : AppPropConst.values()) {
            if (itemMap.containsKey(one.name())) {
                HierarchicalConfiguration item = (HierarchicalConfiguration)itemMap.get(one.name());
                item.setProperty("[@name]", (Object)one.getDesc());
                item.setProperty("[@note]", (Object)one.getNote());
                this.logger.debug("exist config item {}:{}", (Object)one.getDesc(), (Object)one.name());
                continue;
            }
            this.addNewItem(this.cfg, one.getDefVal(), one);
            this.logger.debug("new config item {}:{}", (Object)one.getDesc(), (Object)one.name());
        }
        this.cfg.save(CFG_FILE);
    }

    private void checkTestConfigFile() throws IOException {
        String testConfigFile;
        if (TestConfigTools.isEnable() && StringUtils.hasText((String)(testConfigFile = TestConfigTools.getTestConfigFile()))) {
            this.logger.info("system property testConfigFile : {}", (Object)testConfigFile);
            File file = new File(testConfigFile);
            if (file.exists()) {
                Files.copy((File)file, (File)new File(CFG_FILE));
                this.markSetupOver();
            } else {
                this.logger.info("test config file {} not exist !", (Object)testConfigFile);
            }
        }
    }

    public AppPropBean findOne(AppPropConst code) {
        List items = this.cfg.configurationsAt("item");
        for (HierarchicalConfiguration item : items) {
            if (!code.name().equals(item.getString("[@code]"))) continue;
            AppPropBean tmp = this.convert2Bean(item);
            return tmp;
        }
        return null;
    }

    private AppPropBean convert2Bean(HierarchicalConfiguration item) {
        AppPropConst code = AppPropConst.valueOf((String)item.getString("[@code]"));
        AppPropBean tmp = new AppPropBean();
        tmp.setValue(item.getString(null));
        tmp.setCode(code.name());
        tmp.setSortNumber(code.getSortNumber());
        tmp.setNote(code.getNote());
        tmp.setDesc(code.getDesc());
        tmp.setType(code.getType().name());
        return tmp;
    }

    public List<AppPropBean> findAll() {
        ArrayList rst = Lists.newArrayList();
        List items = this.cfg.configurationsAt("item");
        for (HierarchicalConfiguration item : items) {
            AppPropBean tmp = this.convert2Bean(item);
            rst.add(tmp);
        }
        return rst;
    }

    public List<AppPropBean> findByType(AppPropType ... types) {
        if (types != null && types.length > 0) {
            HashSet typeSet = Sets.newHashSet();
            for (AppPropType type : types) {
                typeSet.add(type.name());
            }
            ArrayList rst = Lists.newArrayList();
            List items = this.cfg.configurationsAt("item");
            for (HierarchicalConfiguration item : items) {
                String code = item.getString("[@code]");
                if (!typeSet.contains(AppPropConst.valueOf((String)code).getType().name())) continue;
                AppPropBean tmp = this.convert2Bean(item);
                rst.add(tmp);
            }
            return rst;
        }
        return this.findAll();
    }

    public boolean isSystemConfigReady() {
        boolean setupOver = new File(SystemPropertyInitListener.getCsHome(), "setupOver").exists();
        boolean netLocationCorrect = Arrays.asList(1, 2).contains(this.findOne(AppPropConst.NETWORK_LOCATION).getInt());
        return netLocationCorrect && setupOver;
    }

    public void markSetupOver() throws IOException {
        Files.touch((File)new File(SystemPropertyInitListener.getCsHome(), "setupOver"));
    }

    public void updateOne(AppPropBean obj) {
        String code = obj.getCode();
        Assert.hasText((String)code);
        try {
            for (HierarchicalConfiguration item : this.cfg.configurationsAt("item")) {
                if (!code.equals(item.getString("[@code]"))) continue;
                item.getRoot().setValue((Object)obj.getValue());
                item.setProperty("[@name]", (Object)obj.getDesc());
                item.setProperty("[@note]", (Object)obj.getNote());
            }
            this.cfg.save(CFG_FILE);
        }
        catch (ConfigurationException e) {
            this.logger.error("update property error", (Throwable)e);
        }
    }

    public void updateOne(String code, String value) {
        Assert.hasText((String)code);
        try {
            for (HierarchicalConfiguration item : this.cfg.configurationsAt("item")) {
                if (!code.equals(item.getString("[@code]"))) continue;
                item.getRoot().setValue((Object)value);
            }
            this.cfg.save(CFG_FILE);
        }
        catch (ConfigurationException e) {
            this.logger.error("update property error", (Throwable)e);
        }
    }

    public void updateSystemConfig(SetupBean setupBean) {
        BeanMap beanMap = BeanMap.create((Object)setupBean);
        try {
            HashMap itemMap = Maps.newHashMap();
            for (HierarchicalConfiguration one : this.cfg.configurationsAt("item")) {
                String code = one.getString("[@code]");
                itemMap.put(code, one);
            }
            for (Object key : beanMap.keySet()) {
                String val = String.valueOf(beanMap.get(key));
                AppPropConst propConst = AppPropConst.valueOf((String)key.toString().toUpperCase());
                if (!StringUtils.hasText((String)val) || "null".equals(val)) continue;
                if (itemMap.containsKey(propConst.name())) {
                    ((HierarchicalConfiguration)itemMap.get(propConst.name())).getRoot().setValue((Object)val);
                    continue;
                }
                this.addNewItem(this.cfg, val, propConst);
            }
            this.cfg.save(CFG_FILE);
        }
        catch (Exception e) {
            this.logger.error("save setup result to {} error", (Object)CFG_FILE, (Object)e);
        }
    }

    private void addNewItem(XMLConfiguration cfg, String val, AppPropConst propConst) {
        this.addNewItem(cfg, val, propConst.name(), propConst.getDesc(), propConst.getNote());
    }

    private void addNewItem(XMLConfiguration cfg, String val, String code, String name, String note) {
        cfg.addProperty("item(-1)", (Object)val);
        cfg.addProperty("item[@code]", (Object)code);
        cfg.addProperty("item[@name]", (Object)name);
        cfg.addProperty("item[@note]", (Object)note);
    }
}

