/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.base.plugins;

import com.xdja.csagent.engine.AgentConnection;
import com.xdja.csagent.engine.AgentMeta;
import com.xdja.csagent.engine.plugins.impl.ConnectionPluginAdapter;
import com.xdja.csagent.webui.base.bean.DefaultAgentMeta;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpIntercepterPlugin
extends ConnectionPluginAdapter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean activeIntercept(AgentConnection connection, AgentMeta config, Map<String, Object> context) {
        boolean result = this.doIntercept(connection, (DefaultAgentMeta)config);
        return result;
    }

    private boolean doIntercept(AgentConnection connection, DefaultAgentMeta cfg) {
        boolean result = false;
        String ip = connection.remoteAddress().getAddress().getHostAddress();
        DefaultAgentMeta config = cfg;
        Integer strategy = config.getIpFilterStrategy();
        if (strategy != 0) {
            if (strategy == 1) {
                result = config.getBlackIpSet().contains(ip);
            } else if (strategy == 2) {
                boolean bl = result = !config.getWhiteIpSet().contains(ip);
            }
        }
        if (result) {
            this.logger.debug("IP Intercepter : true !");
            connection.channel().close();
        } else {
            this.logger.debug("IP Intercepter : false !");
        }
        return result;
    }

    public void applyNewConfig(AgentConnection connection, AgentMeta portConfig) {
        this.doIntercept(connection, (DefaultAgentMeta)portConfig);
    }
}

