/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.agent.action;

import com.google.common.net.InetAddresses;
import com.xdja.common.util.JsonResult;
import com.xdja.csagent.engine.CSEngine;
import com.xdja.csagent.engine.bean.DataSwapStatus;
import com.xdja.csagent.webui.base.action.BaseAction;
import com.xdja.csagent.webui.base.bean.AgentInfoBean;
import com.xdja.csagent.webui.base.entity.AgentParam;
import com.xdja.csagent.webui.base.manager.AgentManager;
import com.xdja.csagent.webui.base.utils.PortRangeUtils;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"agent"})
public class AgentAction
extends BaseAction {
    @Resource
    private AgentManager agentManager;
    @Resource
    private CSEngine agentServer;

    @RequestMapping(value={"index"})
    public String index() {
        return "agent/index";
    }

    @RequestMapping(value={"detailView"})
    public String detailView() {
        return "agent/detail";
    }

    @RequestMapping(value={"addView"})
    public String addView() {
        return "agent/add";
    }

    @RequestMapping(value={"editView"})
    public String editView() {
        return "agent/edit";
    }

    @RequestMapping(value={"showOne"})
    @ResponseBody
    public JsonResult showOne(String agentId) {
        try {
            Assert.hasText((String)agentId, (String)"\u4ee3\u7406ID\u4e0d\u80fd\u4e3a\u7a7a");
            AgentInfoBean agentInfo = this.agentManager.getAgentInfo(agentId);
            return JsonResult.success((Object)agentInfo);
        }
        catch (Exception e) {
            this.logger.error("show one agent {} error", (Object)agentId, (Object)e);
            return JsonResult.failure((String)e.getMessage());
        }
    }

    @RequestMapping(value={"swapStatus"})
    @ResponseBody
    public JsonResult swapStatus() {
        DataSwapStatus swapStatus = this.agentServer.getSwapStatus();
        return JsonResult.success((Object)swapStatus);
    }

    @RequestMapping(value={"showAll"})
    @ResponseBody
    public JsonResult showAll() {
        try {
            return JsonResult.success((Object)this.agentManager.getAgentInfoList());
        }
        catch (Exception e) {
            this.logger.error("show all agent error", (Throwable)e);
            return JsonResult.failure((String)e.getMessage());
        }
    }

    @RequestMapping(value={"addOne"})
    @ResponseBody
    public JsonResult addOne(Integer agentType, Integer agentPort, String agentContext, String destHost, Integer destPort, String destContext, Integer routeLocal, String note) {
        try {
            this.checkAgentArguments(null, agentType, agentPort, agentContext, destHost, destPort, destContext, routeLocal, note);
            AgentParam one = new AgentParam();
            one.setAgentType(agentType);
            one.setAgentPort(agentPort);
            one.setAgentContext(agentContext);
            one.setDestHost(destHost);
            one.setDestPort(destPort);
            one.setDestContext(destContext);
            one.setRouteLocal(routeLocal);
            one.setNote(note);
            this.agentManager.addAgentParam(one);
            return JsonResult.success((Object)true);
        }
        catch (Exception e) {
            this.logger.error("add new agent error:" + e.getMessage());
            return JsonResult.failure((String)e.getMessage());
        }
    }

    @RequestMapping(value={"updateOne"})
    @ResponseBody
    public JsonResult updateOne(String agentId, Integer agentType, Integer agentPort, String agentContext, String destHost, Integer destPort, String destContext, Integer routeLocal, String note) {
        try {
            Assert.hasText((String)agentId, (String)"\u4ee3\u7406ID\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkAgentArguments(agentId, agentType, agentPort, agentContext, destHost, destPort, destContext, routeLocal, note);
            AgentParam one = this.agentManager.getAgentParam(agentId);
            Assert.notNull((Object)one, (String)("ID\u4e3a" + agentId + "\u7684\u4ee3\u7406\u4e0d\u5b58\u5728"));
            one.setAgentType(agentType);
            one.setAgentPort(agentPort);
            one.setAgentContext(agentContext);
            one.setDestHost(destHost);
            one.setDestPort(destPort);
            one.setDestContext(destContext);
            one.setRouteLocal(routeLocal);
            one.setNote(note);
            this.agentManager.updateAgentParam(one);
            return JsonResult.success((Object)true);
        }
        catch (Exception e) {
            this.logger.error("update agent {} error:" + e.getMessage(), (Object)agentId);
            return JsonResult.failure((String)e.getMessage());
        }
    }

    private void checkAgentArguments(String agentId, Integer agentType, Integer agentPort, String agentContext, String destHost, Integer destPort, String destContext, Integer routeLocal, String note) {
        Assert.notNull((Object)agentType, (String)"\u4ee3\u7406\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)agentPort, (String)"\u76d1\u542c\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)PortRangeUtils.ALL_PORT.contains((Comparable)agentPort), (String)"\u76d1\u542c\u7aef\u53e3\u65e0\u6548");
        Assert.isTrue((boolean)this.agentManager.isAgentPortAvailable(agentPort, agentType, agentId), (String)"\u76d1\u542c\u7aef\u53e3\u5df2\u88ab\u4f7f\u7528");
        switch (agentType) {
            case 1: {
                Assert.hasText((String)destHost, (String)"\u76ee\u6807\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.notNull((Object)destPort, (String)"\u76ee\u6807\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((boolean)PortRangeUtils.ALL_PORT.contains((Comparable)destPort), (String)"\u76ee\u6807\u7aef\u53e3\u65e0\u6548");
                break;
            }
            case 2: {
                Assert.hasText((String)agentContext, (String)"\u4ee3\u7406\u4e0a\u4e0b\u6587\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((boolean)agentContext.startsWith("/"), (String)"\u4ee3\u7406\u4e0a\u4e0b\u6587\u5fc5\u987b\u4ee5\"/\"\u5f00\u59cb");
                Assert.isTrue((boolean)this.agentManager.isContextPathAvailabel(agentPort, agentContext, agentId), (String)"\u4ee3\u7406\u4e0a\u4e0b\u6587\u5df2\u88ab\u4f7f\u7528");
                Assert.hasText((String)destHost, (String)"\u76ee\u6807\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((boolean)destHost.startsWith("http://"), (String)"\u76ee\u6807\u5730\u5740\u5fc5\u987b\u4ee5\"http://\"\u5f00\u59cb");
                Assert.notNull((Object)destPort, (String)"\u76ee\u6807\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((boolean)PortRangeUtils.ALL_PORT.contains((Comparable)destPort), (String)"\u76ee\u6807\u7aef\u53e3\u65e0\u6548");
                Assert.hasText((String)destContext, (String)"\u76ee\u6807\u4e0a\u4e0b\u6587\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((boolean)destContext.startsWith("/"), (String)"\u76ee\u6807\u4e0a\u4e0b\u6587\u5fc5\u987b\u4ee5\"/\"\u5f00\u59cb");
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                Assert.hasText((String)destHost, (String)"\u76ee\u6807\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.notNull((Object)destPort, (String)"\u76ee\u6807\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((boolean)PortRangeUtils.ALL_PORT.contains((Comparable)destPort), (String)"\u76ee\u6807\u7aef\u53e3\u65e0\u6548");
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4ee3\u7406\u7c7b\u578b\u9519\u8bef");
            }
        }
        Assert.notNull((Object)routeLocal, (String)"\u672c\u5730\u8def\u7531\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)note, (String)"\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @RequestMapping(value={"deleteOne"})
    @ResponseBody
    public JsonResult deleteOne(String agentId) {
        try {
            if (this.agentManager.isAgentRun(agentId)) {
                return JsonResult.failure((String)"\u5220\u9664\u524d\u8bf7\u5148\u505c\u6b62\u8be5\u4ee3\u7406\u670d\u52a1!");
            }
            this.agentManager.deleteAgentParam(agentId);
            return JsonResult.success((Object)true);
        }
        catch (Exception e) {
            this.logger.error("delete agent {} error", (Object)agentId, (Object)e);
            return JsonResult.failure((String)e.getMessage());
        }
    }

    @RequestMapping(value={"stopOne"})
    @ResponseBody
    public JsonResult stopOne(String agentId) {
        try {
            this.agentManager.stopAgent(agentId);
            return JsonResult.success((Object)true);
        }
        catch (Exception e) {
            this.logger.error("stop agent {} error", (Object)agentId, (Object)e);
            return JsonResult.failure((String)e.getMessage());
        }
    }

    @RequestMapping(value={"startOne"})
    @ResponseBody
    public JsonResult startOne(String agentId) {
        try {
            this.agentManager.startAgent(agentId);
            return JsonResult.success((Object)true);
        }
        catch (Exception e) {
            this.logger.error("start agent {} error", (Object)agentId, (Object)e);
            return JsonResult.failure((String)e.getMessage());
        }
    }

    @RequestMapping(value={"setIpFilter"})
    @ResponseBody
    public JsonResult setIpFilter(String agentId, Integer strategy) {
        try {
            Assert.hasText((String)agentId, (String)"\u4ee3\u7406ID\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)strategy, (String)"\u9ed1\u767d\u540d\u5355\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a");
            this.agentManager.setIpFilter(agentId, strategy.intValue());
            return JsonResult.success((Object)true);
        }
        catch (Exception e) {
            this.logger.error("setIpFilter for agent {} error:" + e.getMessage(), (Object)agentId);
            return JsonResult.failure((String)e.getMessage());
        }
    }

    @RequestMapping(value={"addIpFilter"})
    @ResponseBody
    public JsonResult addIpFilter(String agentId, int type, String ip, String note) {
        try {
            Assert.hasText((String)agentId, (String)"\u4ee3\u7406ID\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)ip, (String)"\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isTrue((boolean)InetAddresses.isInetAddress((String)ip), (String)"\u5730\u5740\u65e0\u6548");
            Assert.hasText((String)note, (String)"\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a");
            this.agentManager.addIpToFilter(agentId, type, ip.trim(), note.trim());
            return JsonResult.success((Object)true);
        }
        catch (Exception e) {
            this.logger.error("addIpToFilter for agent {} error :" + e.getMessage(), (Object)agentId);
            return JsonResult.failure((String)e.getMessage());
        }
    }

    @RequestMapping(value={"disableHttpProtocol"})
    @ResponseBody
    public JsonResult disableHttpProtocol(String agentId, Boolean disableHttpProtocol) {
        try {
            if (this.agentManager.isAgentRun(agentId)) {
                return JsonResult.failure((String)"\u4fee\u6539\u524d\u8bf7\u5148\u505c\u6b62\u8be5\u4ee3\u7406\u670d\u52a1!");
            }
            Assert.hasText((String)agentId, (String)"\u4ee3\u7406ID\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)disableHttpProtocol, (String)"http\u534f\u8bae\u7981\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            this.agentManager.disableHttpProtocol(agentId, disableHttpProtocol);
            return JsonResult.success((Object)true);
        }
        catch (Exception e) {
            this.logger.error("addIpToFilter for agent {} error :" + e.getMessage(), (Object)agentId);
            return JsonResult.failure((String)e.getMessage());
        }
    }

    @RequestMapping(value={"deleteIpFilter"})
    @ResponseBody
    public JsonResult deleteIpFilter(String agentId, int type, String ip) {
        try {
            Assert.hasText((String)agentId, (String)"\u4ee3\u7406ID\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)ip, (String)"\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isTrue((boolean)InetAddresses.isInetAddress((String)ip), (String)"\u5730\u5740\u65e0\u6548");
            this.agentManager.deleteIpFromFilter(agentId, type, ip.trim());
            return JsonResult.success((Object)true);
        }
        catch (Exception e) {
            this.logger.error("deleteIpFromFilter for agent {} error", (Object)agentId, (Object)e);
            return JsonResult.failure((String)e.getMessage());
        }
    }
}

